/*
 * This file redirects memory allocation calls to a private memory manager. The
 * standard ways of calling malloc and free cost too much. The implementation
 * of dmNew and dmFree is in the file dmmem.c and memman.c, which is a straight
 * copy of the OCEAN/src/libseadif/memman.c memory manager.
 */

#define malloc(siz)       dmNew((int)siz)
#define calloc(num,siz)   dmNew((int)(num*siz))

/* realloc() is never used in libddm, so that's one worry less */

/* All calls to free() in de libddm sources have been replaced by calls to
 * dmFree() already, by grep'ing and hand-hacking the sources.
 */

#define free(ptr)         free_does_not_exist_use_dmFree_instead((void *)ptr)

#define DM_UNKNOWN_SIZE   (-1)	  /* second arg for dmFree */

/* generate linker errors if somebody tries to use free(): */
#ifdef __STDC__
void  free_does_not_exist_use_dmFree_instead(char **ptr);
#else
void  free_does_not_exist_use_dmFree_instead();
#endif
