static char *SccsId = "@(#)dmprpth.c 3.7 (TU-Delft) 03/26/91";
/**********************************************************

Name/Version      : The Design Data Management Project

Language          : C
Operating system  : UNIX SYSTEM V
Host machine      : HP9000/S500

Author(s)         : S. de Graaf
                    A. van der Hoeven
                    T.G.R. van Leuken
                    N. van der Meijs
		    T. Vogel
		    P. van der Wolf
Creation date     : 17-Feb-1987
Modified by       : S. de Graaf
Modification date : 26-May-1987


        Delft University of Technology
        Department of Electrical Engineering
        Network Theory Section
        Mekelweg 4 - P.O.Box 5031
        2600 GA DELFT
        The Netherlands

        Phone : 015 - 786234

        COPYRIGHT (C) 1985-1987 , All rights reserved
**********************************************************/
#include "dmstd.h"

#if defined(hpux) || defined(__svr4__) 
#define index strchr
#endif

char   *index ();

/*
** _dmGetProcPath will build a path to the file 'file_name'
** for the process identified by the proc-id that is stored
** in the dmproject key.
*/
char * _dmGetProcPath (dmproject, file_name)
DM_PROJECT * dmproject;
char *file_name;
{
    char * _dmDoGetProcPath ();
    return (_dmDoGetProcPath (dmproject -> procid, file_name));
}

/* actual building of path to process file with the name 'file_name'.
** separate routine with the process_id as its argument, to
** allow dedicated programs to use it without opening a project.
*/
char * _dmDoGetProcPath (process_id, file_name)
int process_id;
char *file_name;
{
    static char buf[MAXLINE];	/* return buffer */
    FILE * fp;
    char    idstr[6];
    char    proc_id[40];
    static int old_process_id = -1;
    static char proc_name[40];
    char   *cp;
    int     i;

    if (process_id == old_process_id)
	goto ready;
    
    old_process_id = -1;

    _dmSprintf (idstr, "%d", process_id);
#ifdef MSDOS
    _dmSprintf (buf, "%s/lib/process/process.lst", icdpath);
#else
    _dmSprintf (buf, "%s/lib/process/processlist", icdpath);
#endif
    fp = fopen (buf, "r");

#ifdef DM_DEBUG
    IFDEBUG
	fprintf (stderr, "fildes: %d, path: %s\n",
	    (fp ? fileno (fp) : -1), buf);
#endif /* DM_DEBUG */

    if (fp == NULL)
	goto e2;

    i = 0;
    while (fgets (buf, MAXLINE, fp) != NULL) {
	if (sscanf (buf, "%s%s", proc_id, proc_name) != 2)
	    continue;
	if (*proc_id == '#')
	    continue;
	if (strcmp (proc_id, idstr) == 0) {
	    ++i;		/* found */
	    break;
	}
    }
    fclose (fp);

    if (!i)
	goto e1;

    if ((cp = index (proc_name, '#')))
	*cp = '\0';
    
    old_process_id = process_id;

ready:
    _dmSprintf (buf, "%s/lib/process/%s/%s", icdpath, proc_name, file_name);
    return (buf);

e1: 
    dmerrno = DME_PRID;
    goto ret;
e2: 
    dmerrno = DME_PRDATA;
    goto ret;
ret: 
    dmError ("_dmGetProcPath");
    return (NULL);
}
