static char *SccsId = "@(#)ITOBS.c 4.2 (TU-Delft) 07/30/91";
/**********************************************************

Name/Version      : libfunc/4.2

Language          : C
Operating system  : UNIX SYSTEM V
Host machine      : GOULD

Author(s)         : O. Hol
Creation date     : 18-Feb-1988
Modified by       : 
Modification date : 


        Delft University of Technology
        Department of Electrical Engineering
        Network Theory Section
        Mekelweg 4 - P.O.Box 5031
        2600 GA DELFT
        The Netherlands

        Phone : 015 - 786234

        COPYRIGHT (C) 1988 , All rights reserved
**********************************************************/
#include <stdio.h>

char * adm_bsalloc();

/* ITOBS()  : converts an integer into a p-bits long bit string           */
/*          : using the radix-2 representation                            */
/*          : a warning is given when integer is too 'big' for bit string */

char * ITOBS (i, p)
int i;
int p;
{
    char * s;
    int n;
    int w;

    s = adm_bsalloc ( p + 1, 'p' );

    if ( i < 0 ){
        fprintf (stderr, "ERROR : ITOBS: integer %d should be positive\n",i);
	return(s);
    }

    if ( p < 8 * sizeof (int) && i > ( (1 << (p)) -1 ) ) {
        fprintf (stderr, "WARNING : ITOBS: integer %d too big for %d bits\n",i,p);
    }

    for (n = 0, w = 1; n < p && n < 8 * sizeof (int) - 1; n++, w *= 2) {
        if (i % (2 * w) > 0) {
            s[p-n-1] = 'I';
            i -= w;
        }
        else {
            s[p-n-1] = 'O';
        }
    }
    while (p-n-1 >= 0) {
        s[p-n-1] = 'O';
	n++;
    }
    s[p] = '\0';

    return (s);
}

