/* SccsId = "@(#)define.h 4.1 (TU-Delft) 05/24/90" */
/**********************************************************

Name/Version      : makebox/4.1

Language          : C
Operating system  : UNIX SYSTEM V
Host machine      : HP9000

Author(s)         : J. Annevelink
Creation date     : 18-May-1983
Modified by       : S. de Graaf
Modification date : 03-Apr-1987


        Delft University of Technology
        Department of Electrical Engineering
        Network Theory Section
        Mekelweg 4 - P.O.Box 5031
        2600 GA DELFT
        The Netherlands

        Phone : 015 - 786234

        COPYRIGHT (C) 1987 , All rights reserved
**********************************************************/
#include "stdio.h"
#include "signal.h"
#include "dmincl.h"

#define P_E   fprintf(stderr,
#define TRUE		1
#define FALSE		0

struct wdw { /* wdw-list element structure */
    long   wdw[4];	    /* window-coordinates */
    struct wdw *next; 	    /* link to next element */
};

struct ctree { /* cell-tree node structure */
    char   name[DM_MAXNAME+1];	/* cell name */
    struct ctree *lchild;	/* left child link */
    struct ctree *rchild;	/* right child link */
};

struct cptrl { /* cell-ptr-list element structure */
    struct ctree *cell;	    /* ptr to cell in cell-tree */
    struct cptrl *next;	    /* link to next element */
};

struct mc_elmt { /* mc-tree element structure */
    char   name[DM_MAXNAME+1];	 /* cell name */
    char   inst_name[DM_MAXNAME+1]; /* instance name */
    long   imported;
    long   bbox[4];		 /* mc-bounding box */
    long   mtx[6];		 /* transf. matrix */
    long   dx, nx;		 /* x-copies */
    long   dy, ny;		 /* y-copies */
    struct wdw *act_regl;	 /* ptr to act-region-list */
    struct mc_elmt *sibling;	 /* link to sibling node */
    struct mc_elmt *child;	 /* link to child node */
    struct mc_elmt *parent;	 /* link to parent node */
};

char   *malloc ();	 /* system routine */
char   *strcpy ();	 /* system routine */
struct ctree *upd_cptrl ();

#define ALLOCPTR(ptr,name) {\
if(!(ptr=(struct name *)malloc(sizeof(struct name))))\
errexit(6,"");}

#define ALLOCARR(ptr,el,name) {\
if(!(ptr=(name *)malloc((unsigned)((el)*sizeof(name)))))\
errexit(6,"");}

#define FREE(ptr) free((char *)(ptr))
