static char *SccsId = "@(#)read_box.c 4.2 (TU-Delft) 06/18/90";
/**********************************************************

Name/Version      : makebox/4.2

Language          : C
Operating system  : UNIX SYSTEM V
Host machine      : HP9000

Author(s)         : J. Annevelink
Creation date     : 18-May-1983
Modified by       : S. de Graaf
Modification date : 11-Feb-1987


        Delft University of Technology
        Department of Electrical Engineering
        Network Theory Section
        Mekelweg 4 - P.O.Box 5031
        2600 GA DELFT
        The Netherlands

        Phone : 015 - 786234

        COPYRIGHT (C) 1987 , All rights reserved
**********************************************************/
#include "extern.h"

/*
** read the boxes of the cell
*/
read_box (pmc)
struct mc_elmt *pmc;
{
    DM_STREAM *fp_box;
    long    xl, xr, yb, yt;
    long    i, j;

    fp_box = dmOpenStream (cellkey, "box", "r");

    while (dmGetDesignData (fp_box, GEO_BOX) > 0) {

	mask_no = gbox.layer_no;

	xl = gbox.xl;
	xr = gbox.xr;
	for (i = 0;;) {
	    yb = gbox.yb;
	    yt = gbox.yt;
	    for (j = 0;;) {
		exp_box (pmc, xl, xr, yb, yt);
		if (++j > gbox.ny) break;
		yb += gbox.dy;
		yt += gbox.dy;
	    }
	    if (++i > gbox.nx) break;
	    xl += gbox.dx;
	    xr += gbox.dx;
	}
    }

    dmCloseStream (fp_box, COMPLETE);
}
