static char *SccsId = "@(#)readterm.c 4.4 (TU-Delft) 01/13/92";
/**********************************************************

Name/Version      : makebox/4.4

Language          : C
Operating system  : UNIX SYSTEM V
Host machine      : HP9000

Author(s)         : S. de Graaf
Creation date     : 22-Apr-1986
Modified by       : S. de Graaf
Modification date : 11-Dec-1987


        Delft University of Technology
        Department of Electrical Engineering
        Network Theory Section
        Mekelweg 4 - P.O.Box 5031
        2600 GA DELFT
        The Netherlands

        Phone : 015 - 786234

        COPYRIGHT (C) 1987 , All rights reserved
**********************************************************/
#include "extern.h"

/*
** read the terminals of the cell
*/
read_term (clp)
struct clist *clp;
{
    DM_STREAM *fp;
    long    xl, xr, yb, yt;
    register long i, j;

    if (tm_s) {
	s_mode = 0;
	if (!part_exp) {
	    fp = dmOpenStream (cellkey, "info", "r");
	    dmGetDesignData (fp, GEO_INFO);
	    ginfo.bxl *= samples;
	    ginfo.bxr *= samples;
	    ginfo.byb *= samples;
	    ginfo.byt *= samples;
	    dmCloseStream (fp, COMPLETE);
	}
	s_exp_box (ginfo.bxl, ginfo.bxr, ginfo.byb, ginfo.byt);
	++s_mode;
    }

    fp = dmOpenStream (cellkey, "term", "r");

    while (dmGetDesignData (fp, GEO_TERM) > 0) {
    /* 
    ** write also a box to the interconnect mask
    ** corresponding with the terminal mask
    */
	mask_no = gterm.layer_no;

	if (tm_p && !clp -> mc_p) {
	    t_mask_no = process -> mask_no[mask_no];
	    gtid.term_offset = term_no;
	    strcpy (gtid.term_name, gterm.term_name);
	    gtid.t_nx = gterm.nx;
	    gtid.t_ny = gterm.ny;
	    if (!nordatahack)
	        dmPutDesignData (fp_tid, GEO_TID);
	}

	xl = samples * gterm.xl;
	xr = samples * gterm.xr;
	gterm.yb *= samples;
	gterm.yt *= samples;
	gterm.dx *= samples;
	gterm.dy *= samples;

	for (i = 0;;) {
	    yb = gterm.yb;
	    yt = gterm.yt;
	    for (j = 0;;) {
		if (tm_p) exp_box (xl, xr, yb, yt);
		if (tm_s) s_exp_box (xl, xr, yb, yt);
		if (++j > gterm.ny) break;
		yb += gterm.dy;
		yt += gterm.dy;
	    }
	    if (++i > gterm.nx) break;
	    xl += gterm.dx;
	    xr += gterm.dx;
	}
    }

    t_mask_no = 0;

    dmCloseStream (fp, COMPLETE);
}
