static char *SccsId = "@(#)chg_group.c 4.1 (TU-Delft) 05/24/90";
/**********************************************************

Name/Version      : makevln/4.1

Language          : C
Operating system  : UNIX SYSTEM V
Host machine      : HP9000

Author(s)         : J. Annevelink
Creation date     : 18-May-1983
Modified by       : S. de Graaf
Modification date : 29-Jan-1987


        Delft University of Technology
        Department of Electrical Engineering
        Network Theory Section
        Mekelweg 4 - P.O.Box 5031
        2600 GA DELFT
        The Netherlands

        Phone : 015 - 786234

        COPYRIGHT (C) 1987 , All rights reserved
**********************************************************/
#include "incl.h"

extern int term_layer;
extern FILE *vln_file, *teq_file;
extern struct S_vln s_vln;
extern struct S_teq s_teq;

chg_group (fp_vln, fp_teq, term_group_offset)
DM_STREAM *fp_vln, *fp_teq;
int term_group_offset;
{
    while (fread ((char *)&s_vln, sizeof (s_vln), 1, vln_file) > 0) {
	gvlnlay.x  = s_vln.x;
	gvlnlay.yb = s_vln.yb;
	gvlnlay.yt = s_vln.yt;
	gvlnlay.occ_type = s_vln.occ;
	gvlnlay.con_type = s_vln.con;
	gvlnlay.chk_type = s_vln.cht;
	gvlnlay.grp_number = fdgrp_name (s_vln.grp) + term_group_offset;
	dmPutDesignData (fp_vln, GEO_VLNLAY);
    }

    if (!term_layer) return;

    while (fread ((char *)&s_teq, sizeof (s_teq), 1, teq_file) > 0) {
	gteq.term_number = s_teq.tnr;
	gteq.grp_number = fdgrp_name (s_teq.grp) + term_group_offset;
	dmPutDesignData (fp_teq, GEO_TEQ);
    }
}
