static char *SccsId = "@(#)find.c 4.1 (TU-Delft) 05/24/90";
/**********************************************************

Name/Version      : makevln/4.1

Language          : C
Operating system  : UNIX SYSTEM V
Host machine      : HP9000

Author(s)         : J. Annevelink
Creation date     : 18-May-1983
Modified by       : S. de Graaf
Modification date : 29-Jan-1987


        Delft University of Technology
        Department of Electrical Engineering
        Network Theory Section
        Mekelweg 4 - P.O.Box 5031
        2600 GA DELFT
        The Netherlands

        Phone : 015 - 786234

        COPYRIGHT (C) 1987 , All rights reserved
**********************************************************/
#include "incl.h"

struct group_list {
    struct group_tree  *group;
    struct group_list  *next;
};

struct group_tree  *fdgrp_ptr (group)
struct group_tree  *group;
{
/* Find the root node of the group_tree from which the
** group is part. Collaps path to root node, and return
** pointer to root node.
*/
    struct group_list  *head = NULL;
    struct group_list  *tmp;

    while (group -> parent && group -> parent -> parent) {
	ALLOCPTR (tmp, group_list);
	tmp -> group = group;
	tmp -> next = head;
	head = tmp;
	group = group -> parent;
    }

    if (group -> parent)
	group = group -> parent;

    while (head) {
	head -> group -> parent = group;
	tmp = head;
	head = head -> next;
	FREE (tmp);
    }

    return (group);
}

fdgrp_name (group)
struct group_tree  *group;
{
/* Find the root node of the group_tree from which the
** group is part. Collaps path to root node, and return
** name of root node.
*/
    struct group_list  *head = NULL;
    struct group_list  *tmp;

    while (group -> parent && group -> parent -> parent) {
	ALLOCPTR (tmp, group_list);
	tmp -> group = group;
	tmp -> next = head;
	head = tmp;
	group = group -> parent;
    }

    if (group -> parent)
	group = group -> parent;

    while (head) {
	head -> group -> parent = group;
	tmp = head;
	head = head -> next;
	FREE (tmp);
    }

    return (group -> tree_count);
}
