static char *SccsId = "@(#)ins_event.c 4.1 (TU-Delft) 05/24/90";
/**********************************************************

Name/Version      : makevln/4.1

Language          : C
Operating system  : UNIX SYSTEM V
Host machine      : HP9000

Author(s)         : J. Annevelink
Creation date     : 18-May-1983
Modified by       : S. de Graaf
Modification date : 29-Jan-1987


        Delft University of Technology
        Department of Electrical Engineering
        Network Theory Section
        Mekelweg 4 - P.O.Box 5031
        2600 GA DELFT
        The Netherlands

        Phone : 015 - 786234

        COPYRIGHT (C) 1987 , All rights reserved
**********************************************************/
#include "incl.h"

extern struct sr_field  *h_sr;
extern struct event_rec *act_event;

/*
** insert an event in the reduced stateruler
*/
insert_event (pr_sr, p_next_stop_pos)
struct  sr_field **pr_sr;
long   *p_next_stop_pos;
{
    struct sr_field *c_sr;

    if (*pr_sr == h_sr) {
    /*
    ** add event at end of stateruler
    */
	c_sr = h_sr -> prev;
	if (act_event -> yb < c_sr -> yt)
	    ins_olf (act_event -> yb,
		Min (act_event -> yt, c_sr -> yt),
		&c_sr, p_next_stop_pos);
	if (act_event -> yt > c_sr -> yt)
	    ins_nwf (Max (act_event -> yb, c_sr -> yt),
		act_event -> yt,
		&c_sr, p_next_stop_pos);
	*pr_sr = h_sr -> prev;
    }
    else {
	c_sr = *pr_sr;
	while (act_event -> yb > c_sr -> yt) {
	/*
	** update reduced stateruler
	*/
	    if ((c_sr = c_sr -> next) == h_sr)
		break;
	}
	*pr_sr = c_sr;

	if (c_sr == h_sr) {
	/*
	** add event at end of stateruler
	*/
	    c_sr = h_sr -> prev;
	    if (act_event -> yb < c_sr -> yt)
		ins_olf (act_event -> yb,
		    Min (act_event -> yt, c_sr -> yt),
		    &c_sr, p_next_stop_pos);
	    if (act_event -> yt > c_sr -> yt)
		ins_nwf (Max (act_event -> yb, c_sr -> yt),
		    act_event -> yt,
		    &c_sr, p_next_stop_pos);
	    *pr_sr = h_sr -> prev;
	}
	else {
	    if (act_event -> yb < c_sr -> yb) {
	    /*
	    ** event is positioned before reduced stateruler
	    */
		ins_nwf (act_event -> yb,
		    Min (act_event -> yt, c_sr -> yb), &(c_sr -> prev),
		    p_next_stop_pos);
		*pr_sr = c_sr -> prev;
	    }

	    if (act_event -> yt > c_sr -> yb
		&& act_event -> yb < c_sr -> yt) {
	    /*
	    ** event overlaps current stateruler field
	    */
		ins_olf (Max (act_event -> yb, c_sr -> yb),
		    Min (act_event -> yt, c_sr -> yt),
		    &c_sr, p_next_stop_pos);
	    }

	    while (act_event -> yt > c_sr -> yt) {
	    /*
	    ** event stretches above current stateruler field
	    */
		if (c_sr -> next == h_sr) {
		/*
		** add event at end of stateruler
		*/
		    ins_nwf (Max (c_sr -> yt, act_event -> yb),
			act_event -> yt,
			&c_sr, p_next_stop_pos);
		    break;
		}
		else {
		    if (c_sr -> yt != c_sr -> next -> yb) {
		    /*
		    ** insert a new field between current and next field
		    */
			ins_nwf (Max (c_sr -> yt, act_event -> yb),
			    Min (c_sr -> next -> yb, act_event -> yt),
			    &c_sr, p_next_stop_pos);
		    }

		    if (act_event -> yt > c_sr -> next -> yb) {
			c_sr = c_sr -> next;
			ins_olf (c_sr -> yb,
			    Min (act_event -> yt, c_sr -> yt),
			    &c_sr, p_next_stop_pos);
		    }
		    else
			c_sr = c_sr -> next;
		}
	    }
	}
    }
}
