static char *SccsId = "@(#)set_group.c 4.1 (TU-Delft) 05/24/90";
/**********************************************************

Name/Version      : makevln/4.1

Language          : C
Operating system  : UNIX SYSTEM V
Host machine      : HP9000

Author(s)         : J. Annevelink
Creation date     : 18-May-1983
Modified by       : S. de Graaf
Modification date : 29-Jan-1987


        Delft University of Technology
        Department of Electrical Engineering
        Network Theory Section
        Mekelweg 4 - P.O.Box 5031
        2600 GA DELFT
        The Netherlands

        Phone : 015 - 786234

        COPYRIGHT (C) 1987 , All rights reserved
**********************************************************/
#include "incl.h"

struct S_teq s_teq;
struct group_tree *merge_groups ();
struct group_tree *group_ptr;
extern struct event_rec *act_event;
extern struct sr_field *h_sr;
extern int   term_layer;
extern FILE *teq_file;
extern long  sr_pos;

set_group (c_sr)
struct sr_field *c_sr;
{
/* set the group_ptr of the stateruler field;
** if its a terminal file, then write a line to the
** teq_file, at least if this has not been done before
*/
    struct group_tree *group1;
    int connect_type = NULL_CONN;

    if (CONNECTED (c_sr -> prev, c_sr))
	if (c_sr -> prev -> duration != sr_pos)
	    connect_type += DOWN_CONN;

    if (CONNECTED (c_sr, c_sr -> next))
	if (c_sr -> next -> duration != sr_pos)
	    connect_type += UP_CONN;

    switch (connect_type) {
    case NULL_CONN: 
	if (c_sr -> group == NULL) {
	    ALLOCPTR (group1, group_tree);
	    c_sr -> group = group1;
	    group1 -> tree_count = 1;
	    group1 -> parent = NULL;
	    group1 -> next = group_ptr;
	    group_ptr = group1;
	}
	break;
    case DOWN_CONN: 
	c_sr -> group = merge_groups (c_sr -> group, c_sr -> prev -> group);
	break;
    case UP_CONN: 
	c_sr -> group = merge_groups (c_sr -> group, c_sr -> next -> group);
	break;
    case TWO_CONN: 
	c_sr -> group = merge_groups (c_sr -> group, c_sr -> prev -> group);
	c_sr -> group = merge_groups (c_sr -> group, c_sr -> next -> group);
	break;
    }

    if (term_layer && act_event -> attr_no >= 0) {
	s_teq.tnr = act_event -> attr_no;
	s_teq.grp = c_sr -> group;
	fwrite ((char *)&s_teq, sizeof (s_teq), 1, teq_file);
	act_event -> attr_no = -1;
    }
}
