static char *SccsId = "@(#)ini_heap.c 4.2 (TU-Delft) 06/18/90";
/**********************************************************

Name/Version      : NBOOL/4.2

Language          : C
Operating system  : UNIX SYSTEM V
Host machine      : HP9000

Author(s)         : J. Liedorp
Creation date     : 31-Jul-1985
Modified by       : J. Liedorp
Modification date : 06-March-1987


        Delft University of Technology
        Department of Electrical Engineering
        Network Theory Section
        Mekelweg 4 - P.O.Box 5031
        2600 GA DELFT
        The Netherlands

        Phone : 015 - 786234

        COPYRIGHT (C) 1985 , All rights reserved
**********************************************************/
#include "nbool.h"

ini_heap (input)
char   *input;			/* contains layernames	 */
{
/* this function initialises the edge_heap		 */

    int     i;			/* loop variable	 */
    int     n_inp;		/* nbr of edge in input	 */
    int     i_str;		/* pointer in inputstring */
    int     i_wrd;		/* pointer in word	 */
    char    lfname[MAXLINE];	/* layer_file		 */
    char    t_lfname[MAXLINE];	/* terminal layer_file	 */
    unsigned int    newmask;	/* bolean mask_id	 */
    int	    newmask_flag;	/* newmask used or not	 */

    nf = 0;
    n_inp = 0;
    i_str = 0;
    i_wrd = 0;

/* reserve the first mask_id's for the masks given in	 */
/* the process.						 */

    newmask = 1;
    newmask = newmask << (process -> nomasks - 1);

/* decodation of the input_string			 */

    while (input[i_str] != '\0') {
	switch (input[i_str]) {
	    case '\040': 
	    case '\t': 
	    case '\n': 
		if (i_wrd != 0) {
		    lfname[i_wrd] = '\0';
		    newmask_flag = insert_file (lfname, newmask, &n_inp, FALSE);
		    if((newmask_flag == NEW_TERMLAY) &&
		       (chk_flag == CHK_HRCHY)) {
			sprintf(t_lfname, "t_%s", lfname);
		        insert_file (t_lfname, newmask, &n_inp, TRUE);
			mask_terms = mask_terms | newmask;
			newmask = newmask << 1;
		    }
		    if(newmask_flag == TRUE) {
			newmask = newmask << 1;
		    }
		    i_wrd = 0;
		}
		i_str++;
		break;
	    default: 
		lfname[i_wrd++] = input[i_str++];
		break;
	}
    }

    if (i_wrd != 0) {
	lfname[i_wrd] = '\0';
        newmask_flag = insert_file (lfname, newmask, &n_inp, FALSE);
        if((newmask_flag == NEW_TERMLAY) && (chk_flag == CHK_HRCHY)) {
	    sprintf(t_lfname, "t_%s", lfname);
	    insert_file (t_lfname, newmask, &n_inp, TRUE);
	    mask_terms = mask_terms | newmask;
	    newmask = newmask << 1;
	}
	if(newmask_flag == TRUE) {
	    newmask = newmask << 1;
        }
	i_wrd = 0;
    }

    if (chk_flag == CHK_HRCHY) {

    /* If the hierarchy is to be checked all masks of the */
    /* process must be read, including the terminal masks. */

	for (i = 1; i < process -> nomasks; ++i) {
	    if (pres_in_heap (n_inp, process -> mask_name[i]) == FALSE) {
		sprintf (lfname, "%s_vln", process -> mask_name[i]);
		newmask_flag = insert_file (lfname, newmask, &n_inp, FALSE);
                if((newmask_flag == NEW_TERMLAY) && (chk_flag == CHK_HRCHY)) {
	            sprintf(t_lfname, "t_%s", lfname);
	            insert_file (t_lfname, newmask, &n_inp, TRUE);
	            mask_terms = mask_terms | newmask;
	            newmask = newmask << 1;
		}
	    }
	}
    }
    nomasks = n_inp;
}

insert_file (lfname, newmask, n_inp, term_lay)
char   *lfname;			/* layer_file		 */
unsigned int    newmask;	/* bolean mask_id	 */
int    *n_inp;			/* nbr in input_heap	 */
int	term_lay;		/* term_layer or not	 */

{
/* This procedure inserts the file given by mod_key and	 */
/* lfname in the edge_heap. If it is a file of a layer	 */
/* known in the process its corresponding parameters	 */
/* such as mask_id and mask_type are taken from it.	 */
/* If not the mask is taken from newmask and the	 */
/* mask_type is set to BOLEAN or to TERM_MASK if	 */
/* term_lay is TRUE.					 */

    register int    i,
                    j;		/* loop variables	 */
    int     newmask_flag;	/* newmask or not	 */
    char    term_name[DM_MAXLAY + 3];/* tmp terminal name */
    char    vln_name[DM_MAXLAY + 7];/* maskname_vln	 */

    for (i = 0; i < process -> nomasks; ++i) {
	sprintf (vln_name, "%s_vln", process -> mask_name[i]);
	if (strcmp (lfname, vln_name) == 0) {
	    edges[*n_inp].mask = (1 << process -> mask_no[i]);
	    edges[*n_inp].mask_type = process -> mask_type[i];
	    strcpy (edges[*n_inp].mask_name, lfname);
	    if ((edges[*n_inp].mask_type == CONN_MASK) &&
		(chk_flag == CHK_HRCHY)) {
		    edges[*n_inp].mask_term = newmask;
		    newmask_flag = NEW_TERMLAY;
	    }
	    else {
	        newmask_flag = FALSE;
	    }
	    break;
	}
    }

    if (i >= process -> nomasks) {
	if (newmask <= (1 << (MAX_NOMASKS - 1))) {
	    edges[*n_inp].mask = newmask;
	    if(term_lay == TRUE)
	        edges[*n_inp].mask_type = TERM_MASK;
	    else
	        edges[*n_inp].mask_type = BOLEAN;
	    strcpy (edges[*n_inp].mask_name, lfname);
	    newmask_flag = TRUE;
	}
	else {
	    fprintf (stderr, "\nERROR in NBOOL:Too many layers asked for\n");
	    die (1);
	}
    }

    edges[*n_inp].fp = dmOpenStream (mod_key, lfname, "r");

    if (dmGetDesignData (edges[*n_inp].fp, GEO_VLNLAY) > 0) {
	edges[*n_inp].pos = gvlnlay.x;
	edges[*n_inp].yb = gvlnlay.yb;
	edges[*n_inp].yt = gvlnlay.yt;
	edges[*n_inp].edge_type = gvlnlay.occ_type;
	edges[*n_inp].chk_type = gvlnlay.chk_type;
	edge_heap[nf] = *n_inp;
	(*n_inp)++;
	nf++;
	mk_heap ();
    }
    else {
	dmCloseStream (edges[*n_inp].fp, COMPLETE);
	(*n_inp)++;
    }

    return (newmask_flag);
}

pres_in_heap (n_inp, mask_name)
int     n_inp;			/* nbr of edges in heap	 */
char   *mask_name;		/* name of the mask	 */
{
/* this procedure returns TRUE if a mask is already	 */
/* present in the edge_heap; FALSE otherwise.		 */
    register int    i;
    char    vln_name[DM_MAXLAY + 7];/* maskname_vln	 */

    for (i = 0; i < n_inp; ++i) {
	sprintf (vln_name, "%s_vln", mask_name);
	if (strcmp (edges[i].mask_name, vln_name) == 0)
	    return (TRUE);
    }
    return (FALSE);
}
