static char *SccsId = "@(#)reheap.c 4.1 (TU-Delft) 05/24/90";
/**********************************************************

Name/Version      : NBOOL/4.1

Language          : C
Operating system  : UNIX SYSTEM V
Host machine      : HP9000

Author(s)         : J. Annevelink
Creation date     : 31-Jan-1985
Modified by       : J. Liedorp
Modification date : 16-Jan-1985


        Delft University of Technology
        Department of Electrical Engineering
        Network Theory Section
        Mekelweg 4 - P.O.Box 5031
        2600 GA DELFT
        The Netherlands

        Phone : 015 - 786234

        COPYRIGHT (C) 1985 , All rights reserved
**********************************************************/
#include "nbool.h"

reheap ()
{
    register int     i, j, k;

    for (i = 1; 2 * i <= nf; i = j) {
	j = 2 * i;
	if (j < nf)		/* find smaller child 	   */
	    if (cmp_occ (edge_heap[j - 1], edge_heap[j]) > 0)
		j++;
	if (cmp_occ (edge_heap[i - 1], edge_heap[j - 1]) <= 0)
	    break;
	k = edge_heap[i - 1];
	edge_heap[i - 1] = edge_heap[j - 1];
	edge_heap[j - 1] = k;
    }
}

mk_heap ()
{
    register int     i, j, k;

    for (i = nf; i > 1; i = j) {
	j = i / 2;
	if (cmp_occ (edge_heap[i - 1], edge_heap[j - 1]) > 0)
	    break;
	k = edge_heap[i - 1];
	edge_heap[i - 1] = edge_heap[j - 1];
	edge_heap[j - 1] = k;
    }
#ifdef DEBUG
    fprintf (stderr, "mk_heap(): Exit\n");
    pr_eheap (0, 20);
#endif
}

cmp_occ (ind1, ind2)	/* compare two occurences */
int     ind1, ind2;
{
    if (edges[ind1].pos < edges[ind2].pos)
	return (-1);

    if (edges[ind1].pos == edges[ind2].pos) {
	if (edges[ind1].yb < edges[ind2].yb)
	    return (-1);

	if (edges[ind1].yb == edges[ind2].yb)
	    return (0);
    }

    return (1);
}
