static char *SccsId = "@(#)readCir.c 3.1 (TU-Delft) 06/08/90";
/**********************************************************

Name/Version      : nspice/3.1

Language          : C
Operating system  : UNIX SYSTEM V
Host machine      : HP9000

Author(s)         : A.J. van Genderen
Creation date     : 8-June-1990
Modified by       :
Modification date :


        Delft University of Technology
        Department of Electrical Engineering
        Network Theory Section
        Mekelweg 4 - P.O.Box 5031
        2600 GA DELFT
        The Netherlands

        Phone : 015 - 786234

        COPYRIGHT (C) 1990 , All rights reserved
**********************************************************/
#include <stdio.h>

#include "define.h"
#include "type.h"
#include "extern.h"

struct node_ref *Begin_table;
struct node_ref *End_table;

readCir (name)
char *name;
{
    char tmp[32];
    char str[132];
    char nodename[132];
    char help[132];
    char c;
    int nr;
    int i;
    long time;
    char *filename;
    FILE *fp;
    struct signal *sig;
    struct node_ref *pr;
    struct node_ref *tab;
    int vnbulk = 0;
    int vpbulk = 0;
    int nbulk = 0;
    int pbulk = 0;
    int error = 0;
    int match;

    sprintf (tmp, "%s", name);
    i = 0;
    while (tmp[i] != ' ' && tmp[i] != '\0') i++;
    tmp[i] = '\0';

    NEW (filename, strlen (tmp) + 5, char);
    sprintf (filename, "%s.spc", tmp);

    if ((fp = fopen (filename, "r")) == NULL) {
	sprintf (help, "Cannot open %s", filename);
	message (help);
	exit (1);
    }

    match = 0;
    c = 'a';
    while (c != EOF && !match) {
	if ((c = getc (fp)) == '*') {
	    while ((c = getc (fp)) == ' ' || c == '\t');
	    if (c != EOF && c != '\n') {
		ungetc (c, fp);
		if (fscanf (fp, "%s", str) == 1 
		&& strcmp ("circuit", str) == 0) {
		    while ((c = getc (fp)) == ' ' || c == '\t');
		    if (c != EOF && c != '\n') {
			ungetc (c, fp);
			if (fscanf (fp, "%s", str) == 1
			&& strcmp (name, str) == 0) {
			     match = 1;
			}
		    }
		}
	    }
	}
	if (c != '\n')
	    while (c != EOF && (c = getc (fp)) != '\n');
    }

    while (fscanf (fp, "%s", str) == 1 && str[0] == '*') {
	while ((c = getc (fp)) != '\n' && c != EOF);
    }

    while (fscanf (fp, "%s", str) == 1 && str[0] != '*') {
	while ((c = getc (fp)) != '\n' && c != EOF);
    }

    while (fscanf (fp, "%s", str) == 1 && str[0] == '*') {
	
	while (fscanf (fp, "%d %s", &nr, nodename) == 2) {

	    if (strcmp (nodename, "nbulk") == 0 
	    || strcmp (nodename, "NBULK") == 0) {
		nbulk = 1;
	    }
	    if (strcmp (nodename, "pbulk") == 0 
	    || strcmp (nodename, "PBULK") == 0) {
		pbulk = 1;
	    }

	    if (Begin_table == NULL) {
		NEW (Begin_table, 1, struct node_ref);
		End_table = Begin_table;
	    }
	    else {
		NEW (End_table -> next, 1, struct node_ref);
		End_table = End_table -> next;
	    }

	    NEW (End_table -> name, strlen (nodename) + 1, char);
	    sprintf (End_table -> name, "%s", nodename);
	    End_table -> nodenr = nr;
	    End_table -> next = NULL;

	    while ((c = getc (fp)) == ' ' || c == '\t');
	    if (c == '\n') 
		break;
	    else
		ungetc (c, fp);
	}

    }

    if (Begin_table == NULL) {
	message ("Cannot find namelist for %s in %s", name, filename);
	exit (1);
    }

    while ((c = getc (fp)) != '\n' && c != EOF);
    while (c != EOF && fscanf (fp, "%s", str) == 1) {
	if (strcmp (str, "vnbulk") == 0 || strcmp (str, "VNBULK") == 0) {
	    vnbulk = 1;
	}
	if (strcmp (str, "vpbulk") == 0 || strcmp (str, "VPBULK") == 0) {
	    vpbulk = 1;
	}
	while ((c = getc (fp)) != '\n' && c != EOF);
    }

    if (nbulk && !vnbulk) {
	message ("Do not use option '-n' with xsls");
	error = 1;
    }
    if (!nbulk && vnbulk) {
	message ("Use option '-n' with xsls");
	error = 1;
    }
    if (pbulk && !vpbulk) {
	message ("Do not use option '-p' with xsls");
	error = 1;
    }
    if (!pbulk && vpbulk) {
	message ("Use option '-p' with xsls");
	error = 1;
    }
    if (error)
	exit (1);

    fclose (fp);

    sig = Begin_signal;
    while (sig) {

	tab = Begin_table;
	while (tab && strcmp (sig -> name, tab -> name) != 0) {
	    tab = tab -> next;
	}

	if (tab == NULL) {
	    message ("Cannot find node %s in %s", sig -> name, filename);
	    exit (1);
	}
	sig -> nodenr = tab -> nodenr;

	sig = sig -> next;
    }

    pr = Begin_print;
    while (pr) {
	
	tab = Begin_table;
	while (tab && strcmp (pr -> name, tab -> name) != 0) {
	    tab = tab -> next;
	}

	if (tab == NULL) {
	    message ("Cannot find node %s in %s", pr -> name, filename);
	    exit (1);
	}
	pr -> nodenr = tab -> nodenr;

	pr = pr -> next;
    }
}

