static char *SccsId = "@(#)emptydir.c 3.6 (TU-Delft) 03/26/91";
/**********************************************************

Name/Version      : rmdb/3.6

Language          : C
Operating system  : UNIX SYSTEM V
Host machine      : HP9000

Author(s)         : S. de Graaf
Creation date     : 22-Feb-1984
Modified by       : S. de Graaf
Modification date : 10-Apr-1987
Modification date : 11-Apr-1988


        Delft University of Technology
        Department of Electrical Engineering
        Network Theory Section
        Mekelweg 4 - P.O.Box 5031
        2600 GA DELFT
        The Netherlands

        Phone : 015 - 786234

        COPYRIGHT (C) 1987-1988, All rights reserved
**********************************************************/
#include "incl.h"

extern char *argv0;
extern char  path[];
extern char  iclf[];
extern int   sw_imp;

empty_dir (view)
char *view;
{
    int fd;

    if (mkdir (view, 0777))
	errexit (-4, view);

    /* create an empty celllist in the view directory: every legal
     * project should have celllists in its view-dirs from now on.
     */
    sprintf (path, "%s/celllist", view);
    if ((fd = creat (path, 0666)) == -1) {
	errexit (-3, path);
    }
    else close (fd);

#ifdef MSDOS
    sprintf (path, "%s/impclist", view);
#else
    sprintf (path, "%s/impcelllist", view);
#endif

    if (sw_imp) {
    /*
    ** create an empty impcelllist in the view directory
    */
	if ((fd = creat (path, 0666)) == -1) {
	    errexit (-3, path);
	}
	else close (fd);
    }
    else {
	if (link (iclf, path)) errexit (2, path);
	if (unlink (iclf)) errexit (-6, iclf);
    }
}

#if defined(OTHERCPU)
mkdir (dir, msk)
char *dir;
int   msk;
{
    int status, w;

    if (fork () == 0) {		/* child */
	umask (msk);
	execl ("/bin/mkdir", "mkdir", dir, 0);
	PE "%s: cannot exec: /bin/mkdir %s\n", argv0, dir);
	exit (1);
    }
    else {
	w = wait (&status);	/* parent */
    }

    return (w == -1 || status);
}
#endif
