static char *SccsId = "@(#)readSet.c 4.13.1.1 (TU-Delft) 05/07/96";
/**********************************************************

Name/Version      : simeye/4.13.1.1

Language          : C
Operating system  : UNIX SYSTEM V
Host machine      : HP9000

Author(s)         : A.J. van Genderen
Creation date     : 29-May-1990
Modified by       : S. de Graaf
Modification date : 09-Apr-1996


        Delft University of Technology
        Department of Electrical Engineering
        Network Theory Section
        Mekelweg 4 - P.O.Box 5031
        2600 GA DELFT
        The Netherlands

        Phone : 015 - 786234

        COPYRIGHT (C) 1990 , All rights reserved
**********************************************************/
#include <stdio.h>
#include <sys/types.h>
#include <sys/stat.h>
#include <dmincl.h>

#include "define.h"
#include "type.h"
#include "extern.h"

extern char *defaultCommandFile;
extern DM_PROJECT *projKey;

extern char *fn_cmd;

extern FILE *yyin;

extern struct node * Begin_node;
extern struct node * End_node;

extern double sigtimeunit;
extern int simperiod;
extern int sigendless;
extern int errorDetected;

extern char *modNameOf ();

extern char inputname[];

extern int s_simperiod;
extern double s_sigunit;

DM_CELL *input_stimuli_key = NULL;

char readSetMes[160];

long curr_time;
long newEndtime;
double Timeconvert;
struct signal *Old_end_signal;

int addSP_level;

void delSigList ();
void adjustSgnPart ();

void windowMessage ();

int readSet (name)
char *name;
{
    char newname[32];
    char help[48];
    int i;
    char *commandfile;
    char *defaultfile; 
    int foundCmd;
    struct signal *sig;
    struct node *n;
    char c;
    FILE *fp_default;
    FILE *fp_copy;
    DM_STREAM *dsp_cmd = NULL;
    struct stat sbuf;


    readSetMes[0] = '\0';

    sprintf (newname, "%s", name);
    i = 0;
    while (newname[i] != ' ' && newname[i] != '\0') i++;
    newname[i] = '\0';

    NEW (commandfile, strlen (newname) + 5, char);
    sprintf (commandfile, "%s.cmd", newname);

    foundCmd = 0;
    usedNonCapital = 0;

    if (use_io_views) {
        if (dmGetMetaDesignData (EXISTCELL, projKey, modNameOf (newname), 
							      STIMULI) == 1) {
	    input_stimuli_key = dmCheckOut (projKey, newname, WORKING,
				            DONTCARE, STIMULI, READONLY);
            if (dmStat (input_stimuli_key, "cmd", &sbuf) == 0) {
		foundCmd = 1;
            }
	    dmCheckIn (input_stimuli_key, COMPLETE);
        }
    }
    else if (stat (commandfile, &sbuf) == 0) {
	foundCmd = 1;
    }

    if (!foundCmd && tryNonCapital 
	&& commandfile[0] >= 'A' && commandfile[0] <= 'Z') {

	/* decapitalize the first character and try to open that file */

	commandfile[0] = commandfile[0] - ('A' - 'a');
	if (stat (commandfile, &sbuf) == 0) {
	    foundCmd = 1;
	    usedNonCapital = 1;
	    sprintf (readSetMes, "editing \"%s\" instead", commandfile);
	}
	else
	    commandfile[0] = commandfile[0] - ('a' - 'A');
    }

    if (!foundCmd) {

	/* try default commandfile */

        fp_default = NULL;
        fp_copy = NULL;

	if ((fp_default = fopen (defaultCommandFile, "r"))) {
	    defaultfile = defaultCommandFile;
	}
	else {
	    if (projKey) {
		if (defaultfile = (char *)dmGetMetaDesignData (PROCPATH, 
                                                 projKey, defaultCommandFile))
		    fp_default = fopen (defaultfile, "r");
	    }
        }

	if (fp_default == NULL) {

	    delSigList (Begin_signal);

	    Nr_signals = 0;

	    Begin_signal = NULL;
	    End_signal = NULL;

	    return (2);                            /* file does not exist */
	}

	if (use_io_views) {
            if (!input_stimuli_key)
		input_stimuli_key = dmCheckOut (projKey, name, WORKING,
					        DONTCARE, STIMULI, UPDATE);
	    dsp_cmd = dmOpenStream (input_stimuli_key, "cmd", "w");
	    fp_copy = dsp_cmd -> dmfp;
            if (fp_copy) {
		sprintf (readSetMes, 
                     "created %s cell \"%s\" from template \"%s\"", 
				  STIMULI, name, defaultfile);
            }
	}
	else {
	    fp_copy = fopen (commandfile, "w");
            if (fp_copy) {
		sprintf (readSetMes, "created \"%s\" from template \"%s\"", 
				      commandfile, defaultfile);
            }
            else {
		sprintf (readSetMes, "Cannot write %s\n", commandfile);
		return (0);
            }
	}

        if (fp_copy) {

	    /* make a copy of the default commandfile */

	    while ((c = getc (fp_default)) != EOF) 
		putc (c, fp_copy);
	    fclose (fp_default);

            if (use_io_views) {
                dmCloseStream (dsp_cmd, COMPLETE);
                dsp_cmd = NULL;
            }
            else {
		fclose (fp_copy);
	    }
	}
    }

    fn_cmd = commandfile;

    updateCommandfile ();

    if (use_io_views) {
	input_stimuli_key = dmCheckOut (projKey, newname, WORKING,
					DONTCARE, STIMULI, READONLY);
	if (dmStat (input_stimuli_key, "cmd", &sbuf) == 0) {
	    dsp_cmd = dmOpenStream (input_stimuli_key, "cmd", "r");
	    yyin = dsp_cmd -> dmfp;
	}
	else {
	    sprintf (readSetMes, 
		     "Cannot open stream 'cmd' of cell %s\n", newname);
	    dmCheckIn (input_stimuli_key, QUIT);
	    return (0);
	}
    }
    else {
	if ((yyin = fopen (commandfile, "r")) == NULL) {
	    sprintf (readSetMes, "Cannot open %s\n", commandfile);
	    return (0);
	}
    }

    /* this function re-initializes the lex scanner: */
    restart_scanner(yyin);

    cmdinits ();

    yyparse ();

    if (use_io_views) {
	if (dsp_cmd)
	    dmCloseStream (dsp_cmd, COMPLETE);
    }
    else
	fclose (yyin);

    if (errorDetected) {
	readSetMes[0] = '\0';   
	/* a windowMessage has already been printed,
	   so do not destroy the message on the screen */
        return (0);
    }

    if (simperiod < 0 && sigendless) {
	sprintf (help, "no end time for input signals in %s", commandfile);
	windowMessage (help, -1);
	return (0);
    }

    if (sigtimeunit < 0)
	sigtimeunit = 1;

    if (Append) {

	Old_end_signal = End_signal;

	/* maintain old value of Timescaling for Timescaling */

	Timeconvert = sigtimeunit / Timescaling;
    }
    else {
	delSigList (Begin_signal);

	Nr_signals = 0;

	Begin_signal = NULL;
	End_signal = NULL;

	Timescaling = sigtimeunit;
    }
    Voltscaling = 2.5;

    if (simperiod >= 0 && sigendless) {

	if (Append) {
	    if (simperiod * Timeconvert * 10 > MAXLONG) {
		windowMessage (
		  "New x values too large (as compared to old x values)", -1);
		delSigList (Old_end_signal -> next);
		Old_end_signal -> next = NULL;
		return (0);
	    }

	    newEndtime = simperiod * Timeconvert;
	}
	else
	    newEndtime = simperiod;
    }
    else
	newEndtime = 0;  /* for initialization */

    n = Begin_node;
    while (n) {
	Nr_signals++;
	NEW (sig, 1, struct signal);
	sig -> name = n -> name;
	sig -> no_edit = n -> no_edit;
	sig -> endless = 0;  /* possibly set in addSgnPart or during editing */
	sig -> stringValue = 0;
	sig -> next = NULL;
	sig -> prev = NULL;
	sig -> layover = NULL;
	sig -> begin_value = NULL;
	sig -> end_value = NULL;
	sig -> begin_value_L = NULL;
	sig -> end_value_L = NULL;
	sig -> begin_value_U = NULL;
	sig -> end_value_U = NULL;
	if (End_signal) {
	    End_signal -> next = sig;
	    sig -> prev = End_signal;
	    End_signal = sig;
	}
	else {
	    Begin_signal = End_signal = sig;
	}

	addSP_level = 0;
        curr_time = 0;
	sig -> expr = n -> expr;
        if (addSgnPart (sig, n -> expr, 1) < 0)
	    return (0);

	if (sig -> endless && addSP_level != 2)
	    sig -> endless = 0;     /* these types of (nested) endless signals
				       are not allowed since they can not be 
				       written back */

        n = n -> next;
    }

    if (simperiod > 0 && !sigendless) {

	/* check if newEndtime should be enlarged */

	if (Append) {
	    if (simperiod * Timeconvert * 10 > MAXLONG) {
		windowMessage (
		  "New x values too large (as compared to old x values)", -1);
		delSigList (Old_end_signal -> next);
		Old_end_signal -> next = NULL;
		return (0);
	    }

            if (simperiod * Timeconvert > newEndtime)
	        newEndtime = simperiod * Timeconvert;
	}
	else {
            if (simperiod > newEndtime)
	        newEndtime = simperiod;
	}
    }

    /* make all new signals end at the time that is Endtime 
       for the current input file */

    if (Append) {
	sig = Old_end_signal -> next;
    }
    else {
	sig = Begin_signal;
    }
    while (sig) {
	adjustSgnPart (sig);
	sig = sig -> next;
    }

    if (Append)
	Endtime = Max (Endtime, newEndtime);
    else {
	Begintime = 0;
	Endtime = newEndtime;
    }
    SimEndtime = Endtime;

    Global_umin = 0;
    Global_umax = 2;

    return (1);
}

void adjustSgnPart (sig)
struct signal *sig;
{
    struct sig_value *sval;
    struct sig_value *sval2;

    if (sig -> end_value) {
	if (sig -> end_value -> time > newEndtime) {
	    sval = sig -> end_value;
	    while (sval && sval -> time > newEndtime) {
		sval2 = sval;
		sval = sval -> prev;
		DELETE (sval2);
	    }
	    if (sval) {
		sval -> next = NULL;
		sig -> end_value = sval;
	    }
	    else {
		sig -> begin_value = NULL;
		sig -> end_value = NULL;
	    }
	}
	if (sig -> end_value -> time < newEndtime) {
	    NEW (sval, 1, struct sig_value);
	    sval -> time = newEndtime;
	    sval -> value = sig -> end_value -> value;
	    sval -> next = NULL;
	    sig -> end_value -> next = sval;
	    sval -> prev = sig -> end_value;
	    sig -> end_value = sval;
	}
    }
}

int addSgnPart (sig, expr, nr)
struct signal *sig;
SIGNALELEMENT *expr;
int nr;
{
    struct sig_value *sval;
    SIGNALELEMENT *sibling_expr;
    int value;
    int ret;
    int newnr;

    if (addSP_level < 100)
	addSP_level++;

    while ((nr > 0 || nr == -1) 
           && (curr_time < simperiod || (simperiod < 0 && curr_time >= 0))) {

	sibling_expr = expr -> sibling;

	while (sibling_expr) {

	    if (sibling_expr -> child) {
		if (sibling_expr -> len > 0 
		    && sibling_expr -> child -> len > 0) {
		    newnr = sibling_expr -> len / sibling_expr -> child -> len;
		}
		else {
		    newnr = -1;
		}
		ret = addSgnPart (sig, sibling_expr -> child, newnr);
		if (ret != 0)
		    return (ret);
	    }
	    else {
		if (sibling_expr -> val == H_state) {
		    value = 2;
		}
		else if (sibling_expr -> val == L_state) {
		    value = 0;
		}
		else if (sibling_expr -> val == X_state) {
		    value = 1;
		}
		else if (sibling_expr -> val == Free_state) {
		    value = -1;
		}
		else {
		    fprintf (stderr, "He ? val = %d\n", sibling_expr -> val);
		}

		if (!sig -> end_value || sig -> end_value -> value != value) {

		    NEW (sval, 1, struct sig_value);

                    if (Append) {

			if (curr_time * Timeconvert * 10 > MAXLONG) {
			    windowMessage (
		    "New x values too large (as compared to old x values)", -1);
			    delSigList (Old_end_signal -> next);
			    Old_end_signal -> next = NULL;
			    return (0);
			}

			sval -> time = curr_time * Timeconvert;
		    }
		    else {
			sval -> time = curr_time;
		    }

		    sval -> value = value;
		    sval -> next = NULL;
		    sval -> prev = NULL;

		    if (sig -> end_value) {
			sig -> end_value -> next = sval;
			sval -> prev = sig -> end_value;
			sig -> end_value = sval;
		    }
		    else {
			sig -> begin_value = sig -> end_value = sval;
		    }
		}

                if (sibling_expr -> len > 0)
		    curr_time = curr_time + sibling_expr -> len;
		else
		    curr_time = simperiod;

		if (simperiod < 0 || !sigendless) {
		    if (Append) {
			if (curr_time * Timeconvert * 10 > MAXLONG) {
			    windowMessage (
		    "New x values too large (as compared to old x values)", -1);
			    delSigList (Old_end_signal -> next);
			    Old_end_signal -> next = NULL;
			    return (-1);
			}
			if (simperiod >= 0) {
			    if (Min (curr_time, simperiod) > newEndtime)
				newEndtime = Min (curr_time, simperiod);
			}
			else
			    if (curr_time > newEndtime)
				newEndtime = curr_time;
		    }
		    else {
			if (simperiod >= 0) {
			    if (Min (curr_time, simperiod) > newEndtime)
				newEndtime = Min (curr_time, simperiod);
			}
			else
			    if (curr_time > newEndtime)
				newEndtime = curr_time;
		    }
		}

		if (simperiod > 0 && sigendless && curr_time > simperiod) {
		    return (1);                 /* end of signal reached */
		}
	    }

	    sibling_expr = sibling_expr -> sibling;
	}

        if (nr == -1)
	    sig -> endless = 1;
	else
	    nr--;
    }

    return (0);
}

int updateCommandfile ()
{
    char commandfile[128];
    char tmpfilename[128];
    char command[128];
    FILE *fp1;
    FILE *fp2;
    char c;
    char c1;
    char c2;
    char *word;
    char buf[128];
    int backslash, goOn;
    int simlevelPre, simlevelNow, simlevelDone;
    int simperiodPre, simperiodNow, simperiodDone;
    int sigunitPre, sigunitNow, sigunitDone;
    int autoSetPresent;
    int autoPrintPresent;
    int autoPlotPresent;
    long firstcharpos;
    DM_CELL *cellKey = NULL;
    DM_STREAM *dsp = NULL;
    DM_CELL *stimuli_key = NULL;
    DM_STREAM *dsp_cmd = NULL;
    char nodename[80];
    int i;
    int copycommand;
    int disablecommand;
    int comment;
    int commentAtBegin;
    int found;
    int l;
    int different;
    char *getword ();
    void windowMessage ();
    int readSignals ();
    void clear ();
    double slstof ();

    sprintf (commandfile, "%s.cmd", modNameOf (inputname));
    sprintf (tmpfilename, "%d.cxx", getpid ());
    usedNonCapital = 0;

    /* set 'option simlevel' to its correct value 
       and update 'automatic' set and print commands */

    if ((fp2 = fopen (tmpfilename, "w")) == NULL) {
	sprintf (command, "Cannot open %s", tmpfilename);
	goto err;
    }

    if (use_io_views) {
        if ((stimuli_key = dmCheckOut (projKey, modNameOf (inputname), WORKING,
                                       DONTCARE, STIMULI, READONLY)) == NULL
            || (dsp_cmd = dmOpenStream (stimuli_key, "cmd", "r")) == NULL) {
	    sprintf (command, "Cannot read %s", commandfile);
	    goto err;
        }
        fp1 = dsp_cmd -> dmfp;
    }
    else {
        if ((fp1 = fopen (commandfile, "r")) == NULL) {

            if (tryNonCapital
		&& commandfile[0] >= 'A' && commandfile[0] <= 'Z') {

		/* decapitalize the first character 
                              and try to open that file */

		commandfile[0] = commandfile[0] - ('A' - 'a');
		fp1 = fopen (commandfile, "r");
		if (fp1)
		    usedNonCapital = 1;
		else
		    commandfile[0] = commandfile[0] - ('a' - 'A');
            }

            if (fp1 == NULL) {
		sprintf (command, "Cannot read %s", commandfile);
		goto err;
	    }
        }
    }

    simlevelDone = 0;
    simperiodDone = 0;
    sigunitDone = 0;
    autoSetPresent = 0;
    autoPrintPresent = 0;
    autoPlotPresent = 0;

    s_simperiod = -1;
    s_sigunit = -1;

    /* first, look if terminals have to be read */

    while ((c = getc (fp1)) != EOF) {

        /* read command by command */

	ungetc (c, fp1);

	firstcharpos = ftell (fp1);

	while ((c = getc (fp1)) == ' ' || c == '\t');

	commentAtBegin = 0;
	if (c == '/' && (c = getc (fp1)) == '*') {
	    commentAtBegin = 1;
	    while ((c = getc (fp1)) == ' ' || c == '\t');
	}
	ungetc (c, fp1);

	word = getword (fp1);

        if (commentAtBegin) {
	    if (compareWord (word, "auto_set")) {
		autoSetPresent = 1;
	    }
	    else if (compareWord (word, "auto_print")) {
		autoPrintPresent = 1;
	    }
	    else if (compareWord (word, "auto_plot")) {
		autoPlotPresent = 1;
	    }
	}

	backslash = 0;
	goOn = 1;
	if (word[0] == '\n' || word[0] == EOF) goOn = 0;
	while (goOn) {

	    word = getword (fp1);

	    if ((word[0] == '\n' && !backslash) || word[0] == EOF)
		goOn = 0;

	    if (word[0] == '\\') 
		backslash = 1;
	    else if (word[0] != ' ' && word[0] != '\t'
                                    && !(word[0] == '\n' && backslash))
		backslash = 0;
	}
    }

    rewind (fp1);

    if (projKey && (autoSetPresent || autoPrintPresent || autoPlotPresent)) {
	cellKey = dmCheckOut (projKey, inputname, WORKING, 
			      DONTCARE, CIRCUIT, READONLY);

	if (cellKey)
	    dsp = dmOpenStream (cellKey, "term", "r");
    }

    /* then, copy fp1 to fp2 but
       without 'automatic' print/plot commands,
       set commands enabled or disabled according to presence in terminal list
       (if auto_set has been defined),
       and option simlevel changed to its correct value */

    comment = 0;
    while ((c = getc (fp1)) != EOF) {

        /* read command by command */

	ungetc (c, fp1);

	firstcharpos = ftell (fp1);

	while ((c = getc (fp1)) == ' ' || c == '\t');

	copycommand = 1;
	disablecommand = 0;

	commentAtBegin = 0;
	if (c == '/' && (c = getc (fp1)) == '*') {
	    commentAtBegin = 1;
	    while ((c = getc (fp1)) == ' ' || c == '\t');
	}
	ungetc (c, fp1);

	word = getword (fp1);

        if (commentAtBegin) {
	    if (compareWord (word, "begin_disabled")) {
		copycommand = 0;
	    }
	}
	else {
	    if (compareWord (word, "print")
		|| compareWord (word, "plot")) {

		while ((c = getc (fp1)) == ' ' || c == '\t');

		if (c == '/' && (c = getc (fp1)) == '*') {

		    while ((c = getc (fp1)) == ' ' || c == '\t');
		    ungetc (c, fp1);

		    word = getword (fp1);
		    if (compareWord (word, "auto")) {
			copycommand = 0;         /* it is an 'automatic' 
					            print/plot command */
		    }
		}
	    }
	    if (autoSetPresent && compareWord (word, "set")) {

		while ((c = getc (fp1)) == ' ' || c == '\t' 
				   || c == '\\' || c == '\n');

                nodename[0] = '\0';
		if ((c == '/' || c == '#') && (c = getc (fp1)) == '*') {

		    while ((c = getc (fp1)) == ' ' || c == '\t');
                    ungetc (c, fp1);

                    word = getword (fp1);
                    if (compareWord (word, "no_edit")) {

                        c2 = ' ';
			while (c != EOF 
                               && !(c2 == '*' && (c == '/' || c == '#'))) {
                            c2 = c;
                            c = getc (fp1);
                        }

			while ((c = getc (fp1)) == ' ' || c == '\t' 
					  || c == '\\' || c == '\n');
			ungetc (c, fp1);

			i = 0;
			while (((c = getc (fp1)) >= 'a' && c <= 'z')
			       || (c >= 'A' && c <= 'Z')
			       || (c >= '0' && c <= '9')
			       || c == '_') {
				nodename[i++] = c;
			}
			nodename[i] = '\0';
		    }
                }

		/* If we have have found a nodename of a non-editable set 
                   command, look if nodename is part of the terminal list */

		found = 1;
		if (nodename[0] != '\0' && dsp) {
		    found = 0;
		    while (dmGetDesignData (dsp, CIR_TERM) > 0 && !found) {
			if (strcmp (cterm.term_name, nodename) == 0) {
			    found = 1;
			}
		    }
		    dmSeek (dsp, (long)0, (long)0);  /* rewind */
		}
		if (!found)
		    disablecommand = 1;
	    }
	    if (compareWord (word, "end_disabled")) {
		copycommand = 0;
	    }
	}

        if (disablecommand) {
	    fprintf (fp2, "/* begin_disabled\n");
	}

	fseek (fp1, firstcharpos, 0);

	simlevelPre = 0, simlevelNow = 0;
	simperiodPre = 0, simperiodNow = 0;
	sigunitPre = 0, sigunitNow = 0;

	backslash = 0;
	goOn = 1;
	while (goOn) {

	    word = getword (fp1);

            l = strlen (word);
            for (i = 0; i < l; i++) {
                if (word[i] == '/' && word[i+1] == '*')
                    comment = 1;
                else if (word[i] == '*' && word[i+1] == '/')
                    comment = 0;
            }

	    if (simlevelNow 
		&& (word[0] >= '0' && word[0] <= '9')) {
		fprintf (fp2, "%d ", SimLevel);
		simlevelNow = 0;
		simlevelDone = 1;
	    }
	    else if (simperiodNow) {
		sscanf (word, "%d", &s_simperiod);
		simperiodNow = 0;
		simperiodDone = 1;

		fprintf (fp2, "%s", word);
	    }
	    else if (sigunitNow) {
		sscanf (word, "%s", buf);  /* to remove trailing spaces */
		s_sigunit = slstof (buf);
		sigunitNow = 0;
		sigunitDone = 1;

		fprintf (fp2, "%s", word);
	    }
	    else if (copycommand && word[0] != EOF) {

		/* see if comment has to be converted */

		l = strlen (word);
                if (disablecommand) {
		    if (word[l - 2] == '/' && word[l - 1] == '*')
			word[l - 2] = '#';
		    if (word[l - 2] == '*' && word[l - 1] == '/')
			word[l - 1] = '#';
		}
		else {
		    if (word[l - 2] == '#' && word[l - 1] == '*')
			word[l - 2] = '/';
		    if (word[l - 2] == '*' && word[l - 1] == '#')
			word[l - 1] = '/';
		}

		fprintf (fp2, "%s", word);
	    }

            if (!comment) {
		if (simlevelPre) {
		    if (word[0] == '=') {
			simlevelNow = 1;
			simlevelPre = 0;
		    }
		    else if (word[0] != '\\')
			simlevelPre = 0;
		}

		if (simperiodPre) {
		    if (word[0] == '=') {
			simperiodNow = 1;
			simperiodPre = 0;
		    }
		    else if (word[0] != '\\')
			simperiodPre = 0;
		}

		if (sigunitPre) {
		    if (word[0] == '=') {
			sigunitNow = 1;
			sigunitPre = 0;
		    }
		    else if (word[0] != '\\')
			sigunitPre = 0;
		}

		if (compareWord (word, "level"))
		    simlevelPre = 1;
		if (compareWord (word, "simperiod"))
		    simperiodPre = 1;
		if (compareWord (word, "sigunit"))
		    sigunitPre = 1;
	    }
		    
	    if ((word[0] == '\n' && !backslash) || word[0] == EOF)
		goOn = 0;

	    if (word[0] == '\\') 
		backslash = 1;
	    else if (word[0] != ' ' && word[0] != '\t'
                                    && !(word[0] == '\n' && backslash))
		backslash = 0;
	}

        if (disablecommand) {
	    fprintf (fp2, "   end_disabled */\n");
	}
    }

    if (s_sigunit <= 0)
	s_sigunit = 1;   /* default */

    /* then, add simlevel (if not yet defined) and add print/plot commands 
       that are automatically determined from the terminal list of the cell
       that is simulated  */

    if (!simlevelDone)
	fprintf (fp2, "option level = %d\n", SimLevel);

    if (autoPrintPresent || autoPlotPresent) {

	if (dsp) {
	    while (dmGetDesignData (dsp, CIR_TERM) > 0) {

		if (autoPrintPresent) {
		    fprintf (fp2, "print /* auto */ %s", cterm.term_name);
		    for (i = 0; i < cterm.term_dim; i++) {
			if (i == 0)
			    fprintf (fp2, "[");
			else 
			    fprintf (fp2, ",");
			fprintf (fp2, "%d..%d", 
				 cterm.term_lower[i], cterm.term_upper[i]);
			if (i == cterm.term_dim - 1)
			    fprintf (fp2, "]");
		    }
		    fprintf (fp2, "\n");
		}

		if (autoPlotPresent) {
		    fprintf (fp2, "plot /* auto */ %s", cterm.term_name);
		    for (i = 0; i < cterm.term_dim; i++) {
			if (i == 0)
			    fprintf (fp2, "[");
			else 
			    fprintf (fp2, ",");
			fprintf (fp2, "%d..%d", 
				 cterm.term_lower[i], cterm.term_upper[i]);
			if (i == cterm.term_dim - 1)
			    fprintf (fp2, "]");
		    }
		    fprintf (fp2, "\n");
		}
	    }
	}
    }

    /* check if the files are different */

    rewind (fp1);
    fclose (fp2);
    if ((fp2 = fopen (tmpfilename, "r")) == NULL) {
	sprintf (command, "Cannot open %s", tmpfilename);
	goto err;
    }

    c1 = getc (fp1);
    c2 = getc (fp2);
    while (c1 == c2 && c1 != EOF) {
	c1 = getc (fp1);
	c2 = getc (fp2);
    }

    if (c1 == EOF && c2 == EOF)
	different = 0;
    else
	different = 1;

    /* close files */

    if (dsp)
	dmCloseStream (dsp, COMPLETE);
    if (cellKey)
	dmCheckIn (cellKey, COMPLETE);

    if (use_io_views) {
	dmCloseStream (dsp_cmd, COMPLETE);
	dmCheckIn (stimuli_key, COMPLETE);
    }
    else
	fclose (fp1);

    fclose (fp2);

    /* finally move tmpfile to commandfile if something has changed */

    if (different) {
	if (use_io_views) {
	    stimuli_key = dmCheckOut (projKey, modNameOf (inputname), WORKING, 
				      DONTCARE, STIMULI, UPDATE);
#if NCF_RELEASE >= 400
	    dmMoveFileToStream (stimuli_key, tmpfilename, "cmd");
#endif
	    dmCheckIn (stimuli_key, COMPLETE);
	}
	else {
	    sprintf (command, "mv %s %s", tmpfilename, commandfile);
	    system (command);
	}
    }
    else {
	unlink (tmpfilename);
    }

    return (0);
err:
    if (fp2 != NULL) fclose (fp2);
    unlink (tmpfilename);
    windowMessage (command, -1);
    return (1);
}
