static char *SccsId = "@(#)debug.c 3.1 (TU-Delft) 04/16/87";
/**********************************************************

Name/Version      : sldm/3.1

Language          : C
Operating system  : UNIX SYSTEM V
Host machine      : HP9000

Author(s)         : N. van der Meijs
Creation date     : 17-Oct-1984
Modified by       :
Modification date :


        Delft University of Technology
        Department of Electrical Engineering
        Network Theory Section
        Mekelweg 4 - P.O.Box 5031
        2600 GA DELFT
        The Netherlands

        Phone : 015 - 786234

        COPYRIGHT (C) 1984 , All rights reserved
**********************************************************/
# include "sldm.h"

static char    *namelist[BUFSIZ];

boolean ifDebug (file, line)
char   *file;
int     line;
{
    static  boolean init = TRUE;
    static  FILE   * dfp = NULL;
    char  * getenv     ();
    void    init_debug ();
    boolean check      ();

    if (init == TRUE) {
	init = FALSE;
	if (getenv ("DEBUG") && (dfp = fopen (getenv ("DEBUG"), "r")))
	    init_debug (dfp);
    }
    if (*namelist)
	return (check (file, line));
    else 
	return (FALSE);
}

/* init_debug - read debuging file and install names in list */

static void init_debug (dfp)
FILE * dfp;
{
    register int    i = 0;
    char  * strsave ();
    char  * fgets   ();
    char    buf[BUFSIZ];

    while (fgets (buf, BUFSIZ, dfp)) {
	buf[strlen (buf) - 1] = '\0';
	namelist[i++] = strsave (buf);
    }
    namelist[i] = NULL;

    return;
}

/* check - check if 'file' is present in list */

static boolean check (file, line)
char   *file;
int     line;
{
    register int    i;

    for (i = 0; namelist[i] != NULL; i++) {
	if (strcmp (namelist[i], file) == 0) {
	    fprintf (stderr, "---%s, %d:\n", file, line);
	    return (TRUE);
	}
    }
    return (FALSE);
}

/* dumpStretch - dump a stretch node */

void dumpStretch (fp, sp)
FILE * fp;
STRETCH * sp;
{
    static  boolean dump = FALSE;
    if (fp && sp) {
	if (dump == FALSE) {
	    dump = TRUE;
	    fprintf (fp,
	    "    label       lo       hi      pos      val     line");
	    fprintf (fp,
	    "      dir    p_mod    m_mod   addres     prev     next\n");
	}
	fprintf (fp, "%9d%9d%9d%9d%9d%9d%9c%9s%9s%9d%9d%9d\n",
		sp -> label,
		sp -> lo,
		sp -> hi,
		sp -> pos,
		sp -> val,
		sp -> line,	/* label for error messages */
		sp -> dir,
		sp -> p_mod,
		sp -> m_mod,
		sp,
		sp -> prev,
		sp -> next);
    }
}

static char *strsave (s)
char   *s;
{
    char *malloc ();
    char *strcpy ();
    void  exit   ();
    char   *p = NULL;

    if (p = malloc ((unsigned) strlen (s) + 1))
	(void) strcpy (p, s);
    else
	die ("no more core", NULL);

    return (p);
}
