/* SccsId = "@(#)sldm.h 3.1 (TU-Delft) 04/16/87" */
/**********************************************************

Name/Version      : sldm/3.1

Language          : C
Operating system  : UNIX SYSTEM V
Host machine      : HP9000

Author(s)         : N. van der Meijs
Creation date     : 17-Oct-1984
Modified by       :
Modification date :


        Delft University of Technology
        Department of Electrical Engineering
        Network Theory Section
        Mekelweg 4 - P.O.Box 5031
        2600 GA DELFT
        The Netherlands

        Phone : 015 - 786234

        COPYRIGHT (C) 1984 , All rights reserved
**********************************************************/
/* sldm.h - external declarations and macro definitions */

# include <stdio.h>

typedef enum {FALSE, TRUE} boolean;

/*
 * DEBUGGING MACROS
 */

# ifdef  DEBUG
# undef  DEBUG
# define DEBUG ifDebug(__FILE__,__LINE__)
# define YYDEBUG 1
# define PANIC(a1, a2) panic (__FILE__, __LINE__, a1, a2)

extern boolean ifDebug ();
extern void dumpStretch ();

# else NO DEBUGGING
# define PANIC(a1, a2) panic ((char *) 0, 0, a1, a2)
# endif

# define EOS '\0'

# define ERROR 0
# define OK 1

# define XDIR 'x'
# define YDIR 'y'
# define HIGHER 1        /* return value of where */
# define HEDGE 2         /* return value of where */
# define MID 3           /* return value of where */
# define LEDGE 4         /* return value of where */
# define LOWER 5         /* return value of where */
# define NEXT 6          /* return value of where */
# define CANT 7          /* return value of check */
# define DONT 8          /* return value of check */
# define MX 'x'          /* mirror in x-axis */
# define MY 'y'          /* mirror in y-axis */
# define R3 90           /* rotate 90 degrees */
# define R6 180          /* rotate 180 degrees */
# define R9 270          /* rotate 270 degrees */
# define MAXNAME 8       /* number of chars in a ldm name */
# define MAXVALS 50      /* number of stretch arguments */
# define MAXPATH 100     /* number of characters in a pathname */
# define MAXNAMES 15     /* number of new names, -n name arguments */
# define NMFS 8          /* number of modifiers, equal to number of layers */
# define FBOXFMT "b %c %d %d %d %d %d %d %d %d\n"
# define FTERMFMT "t %c %d %d %d %d %s %d %d %d %d\n"

/* allocation macro */

extern char *malloc ();
# define alloc(object) (object *)malloc(sizeof(object))

# define min(a,b) ( (a) < (b) ? (a) : (b) )
# define max(a,b) ( (a) > (b) ? (a) : (b) )

/*
 * structure typedefs
 */

typedef struct {
   char  name[MAXNAME + 1];
   char  inst_name[MAXNAME + 1];
   int   mir, rot, tx, ty, dx, nx, dy, ny;
} MC;

typedef struct {
   char  name[MAXNAME + 1];
   int   xl, xr, yb, yt;
   int dx, nx, dy, ny;
   int   layer;
} TERM;

typedef struct {
   int   xl, xr, yb, yt;
   int dx, nx, dy, ny;
   int   layer;
} BOX;

typedef struct {
    char name[MAXNAME+1];
} MS;

typedef struct {
    char name[MAXNAME+1];
} ME;

typedef struct str_node {
    int label;
    int layer;
    int lo, hi, pos;
    int val;
    int line;   /* label for error messages */
    int dir;
    char p_mod[NMFS+1];   /* plus modifier */
    char m_mod[NMFS+1];   /* min modifier */
    char t_mod[NMFS+1];   /* touch modifier */
    struct str_node * prev;
    struct str_node * next;
} STRETCH;

/*
** some function declarations
*/

extern void die ();
extern void error ();
extern void panic ();
