static char *SccsId = "@(#)hiername.c 4.1 (TU-Delft) 05/23/90";
/**********************************************************

Name/Version      : sls_exp/4.1

Language          : C
Operating system  : UNIX SYSTEM V
Host machine      : HP9000

Author(s)         : A.J. van Genderen
Creation date     : 10-Jul-1986
Modified by       : S. de Graaf
Modification date : 10-Jul-1986


        Delft University of Technology
        Department of Electrical Engineering
        Network Theory Section
        Mekelweg 4 - P.O.Box 5031
        2600 GA DELFT
        The Netherlands

        Phone : 015 - 786234

        COPYRIGHT (C) 1986 , All rights reserved
**********************************************************/
#include "extern.h"

char hierstr[300];  /* memory space for the name contructed */

char * hiername (nx)  /* gives the hierarchical name of node nx */
int nx;
{
    char * dummy;
    char * rec_hiername ();

    if (N[nx].ntx < 0) {
	strcpy (hierstr, "<no name>");
    }
    else {
        dummy = rec_hiername (nx, -1, hierstr);
    }

    return (hierstr);
}

char * rec_hiername (nx, mctx, totstr)   /* recursive hier. name constructor */
int nx;    /* index of the node */
int mctx;  /* model call in which this node must hierarchically be searched. */
           /* nx < 0 or mctx < 0.  when nx < 0 the modelcall mctx must       */
	   /* be constructed and when mctx < the node name nx must be        */
	   /* constructed */
char * totstr;  /* the total name will be constructed in totstr */
                /* rec_hiername returns as value a pointer to the character */
		/* after the last character of the name constructed so far  */
{
    int xtx;
    int ntx;
    int xx;
    int offset;
    int rest;
    int cnt;
    int up;
    int low;
    int middle;
    int nextmctx;
    int dindex;
    char index[16];  /* contains an integer */
    int i;
    char * endstr;
    char * str;
    char * rec_hiername ();

    if (nx >= 0) {
	                       /* find node name */
	ntx = N[nx].ntx;            
	if (NT[ntx].xtx >= 0) {
	    xx = NT[ntx].x;
	    while (XX[xx++] != nx);
	    offset = xx - 1 - NT[ntx].x;
	}
	else
	    offset = 0;

	/* find the modelcall in which the node is actually called */
	low = 0;
	up = CTT_cnt - 1;
	while (low < up - 1) {
	    middle = (up + low)/2;
	    if ( CTT[middle].ceiling > nx )
		up = middle;
	    else
		low = middle;
	}
	if (CTT[low].ceiling > nx) {   /* it could be possible low is still 0 */
	    /* low = -1;  (is not neccessary) */
	    up = 0;
	}
	i = up;
	nextmctx = CTT[i].mctx;
    }
    else {
	if (mctx < 0) {
	    return (totstr);  /* both nx and mctx are < 0, so ready ! */
	}
	else {
				      /* find modelcall name */
	    ntx = MCT[mctx].ntx;
	    offset = mctx - NT[ ntx ].x;

	    /* find modelcall in which this modelcall is called */
	    nextmctx = MCT[mctx].parent;
	}
    }

    /* firstly, construct name of the higher hierarchy */

    str = rec_hiername (-1, nextmctx, totstr);

    /* then, add the name of this hierarchy */

    xtx = NT[ ntx ].xtx;

    strcpy (str, ST + NT[ntx].name);

    endstr = str + strlen(str);

    if (xtx >= 0) { 
                      /* construct the indices with XT and offset information */

        *endstr++ = '[';

        rest = 1;
        i = xtx + 1;
        for (cnt = 1; cnt <= XT[xtx]; cnt++) {
	    rest = rest * (XT[i+1] - XT[i] + 1);
	    i = i + 2;
        }
	
        i = xtx + 1;
        for (cnt = 1; cnt <= XT[xtx]; cnt++) {
	    rest = rest / (XT[i+1] - XT[i] + 1);
	    dindex = offset / rest;
	    offset = offset - dindex * rest;
	    sprintf (index, "%d", XT[i] + dindex);
	    sprintf (endstr, "%s", index);
            endstr = endstr + strlen(index);
	    if (cnt < XT[xtx])
                *endstr++ = ',';
	    i = i + 2;
        }
	
        *endstr++ = ']';

    }

    if (nx >= 0)
        *endstr++ = '\0';
    else
	*endstr++ = '.';

    return (endstr);
}
