static char *SccsId = "@(#)alarm.c 4.3 (TU-Delft) 01/28/93";
/**********************************************************

Name/Version      : aux/4.3

Language          : C
Operating system  : UNIX SYSTEM V
Host machine      : HP9000

Authors           : A.J. van Genderen
                  : N.P. van der Meijs
Creation date     : 10-Jun-1988
Modified by       :
Modification date :


        Delft University of Technology
        Department of Electrical Engineering
        Network Theory Section
        Mekelweg 4 - P.O.Box 5031
        2600 GA DELFT
        The Netherlands

        Phone : 015 - 786234

        COPYRIGHT (C) 1988. All rights reserved.
**********************************************************/
#include "signal.h"

static int Sec;
static void (* Handler) ();

/* setAlarmInterval
 *    Set up a handler for the SIGALRM signal,
 *    and send an alarm every sec seconds,
 *    so that handler is invoked.
 *    If sec <= 0, do not send signals automatically but
 *    set up handler anyway to respond to externally (keyboard)
 *    generated alarms.
 */
setAlarmInterval (sec, handler)
int sec;
void (* handler) ();
{
    void catcher ();

    if (signal (SIGALRM, SIG_IGN) != SIG_IGN) {
	Sec = sec;
	Handler = handler;
	signal (SIGALRM, catcher);
	if (Sec) alarm (Sec);
    }
}

static
void catcher (sig)
int sig;
{
    (*Handler) ();
    signal (sig, catcher);
    if (Sec) alarm (Sec);
}

#ifdef DRIVER

/* a test driver and an example.
 */
main (argc, argv)
int argc;
char * argv[];
{
    int i;
    void onAlarm ();

    if (argc > 1) i = atoi (argv[1]);
    else          i = 5;

    setAlarmInterval (i, onAlarm);
    while (1);			/* or something other useful */
    exit (0);
}

static void onAlarm ()
{
    char * ctime ();
    long   time  ();
    long * clock;

    clock = time (0);
    printf ("%s", ctime (&clock));
}
#endif /* DRIVER */
