static char *SccsId = "@(#)signal.c 4.4 (TU-Delft) 04/21/93";
/**********************************************************

Name/Version      : aux/4.4

Language          : C
Operating system  : UNIX SYSTEM V
Host machine      : HP9000

Authors           : A.J. van Genderen
                  : N.P. van der Meijs
Creation date     : 15-Mar-1988
Modified by       :
Modification date :


        Delft University of Technology
        Department of Electrical Engineering
        Network Theory Section
        Mekelweg 4 - P.O.Box 5031
        2600 GA DELFT
        The Netherlands

        Phone : 015 - 786234

        COPYRIGHT (C) 1988. All rights reserved.
**********************************************************/
#include <signal.h>

/*
 * Set up signal handling for the usual signals:
 *      SIGILL SIGFPE SIGBUS SIGSEGV SIGINT SIGQUIT
 *
 * The associated signal handler will print a message
 * (using say) and then invoke die ().
 *
 * This lib contains a default die (), to be redefined
 * in an application.
 */
void catchSignals ()
{
    int onsig ();

    if (signal (SIGINT, SIG_IGN) != SIG_IGN)
	signal (SIGINT, onsig);
#   ifndef DEBUG
    if (signal (SIGQUIT, SIG_IGN) != SIG_IGN)
        signal (SIGQUIT, onsig);
    signal (SIGTERM, onsig);
    signal (SIGILL, onsig);
    signal (SIGFPE, onsig);
#   ifdef SIGBUS
    signal (SIGBUS, onsig);
#   endif
    signal (SIGSEGV, onsig);
#   endif /* DEBUG */
}

static int onsig (sig)   /* interrupt handler */
int sig;
{
    signal (sig, SIG_IGN);
    switch (sig) {
        case SIGILL:  say ("Illegal instruction");      break;
        case SIGFPE:  say ("Floating point exception"); break;
#       ifdef SIGBUS
        case SIGBUS:  say ("Bus error");                break;
#       endif
        case SIGSEGV: say ("Segmentation violation");   break;
	case SIGINT:  say ("Interrupt");                break;
	case SIGQUIT: say ("Quit");                     break;
	default:      say ("Signal %d", sig);           break;
    }

    die ();
    signal (sig, onsig);
}
