/* SccsId = "@(#)lump.h 4.7 (TU-Delft) 05/14/93" */
/**********************************************************

Name/Version      : space/4.7

Language          : C
Operating system  : UNIX SYSTEM V
Host machine      : HP9000

Author(s)         : A.J. van Genderen
		  : N.P. van der Meijs
Creation date     : 15-Mar-1988
Modified by       :
Modification date :


        Delft University of Technology
        Department of Electrical Engineering
        Network Theory Section
        Mekelweg 4 - P.O.Box 5031
        2600 GA DELFT
        The Netherlands

        Phone : 015 - 786234

        COPYRIGHT (C) 1988. All rights reserved.
**********************************************************/
typedef struct element {
    char type;
} element_t;

typedef struct group {
    short notReady;
    short adjGrpNotReady;
    int nod_cnt;
    int res_cnt;
    int cap_cnt;
    unsigned supply : 8;
    unsigned prick : 8;
    unsigned noResis : 16;
    float rSource;
    struct groupTileInfo * tileInfo;
} group_t;

typedef struct nodeTorLink {
    struct nodeTorLink * nextN;
    struct nodeTorLink * prevN;
    struct node * n;
    struct nodeTorLink * nextT;
    struct nodeTorLink * prevT;
    struct transistor * t;
    char type;  /* 'g' or 'd' */
} nodeTorLink_t;

typedef struct netEquiv {
    char instType;
    char term;
    int number;
    struct node * net;
    struct netEquiv * nextDsRing;
    struct netEquiv * next;
} netEquiv_t;

typedef struct groupTileInfo {
    double resWeight;
    struct tileRef * tiles;
} groupTileInfo_t;

typedef struct tileRef {
    int tile;
} tileRef_t;

typedef struct strRef {
    char * str;
    struct strRef * next;
} strRef_t;
