/* SccsId = "@(#)tile.h 4.4 (TU-Delft) 04/20/93" */
/**********************************************************

Name/Version      : space/4.4

Language          : C
Operating system  : UNIX SYSTEM V
Host machine      : HP9000

Author(s)         : A.J. van Genderen
		  : N.P. van der Meijs
Creation date     : 15-Mar-1988
Modified by       :
Modification date :


        Delft University of Technology
        Department of Electrical Engineering
        Network Theory Section
        Mekelweg 4 - P.O.Box 5031
        2600 GA DELFT
        The Netherlands

        Phone : 015 - 786234

        COPYRIGHT (C) 1988. All rights reserved.
**********************************************************/


#ifndef tile_h
#define tile_h

#ifdef DOUBLE
/* Use double for geo coordinates.
 * Could include values.h to obtain MAXDOUBLE,
 * but values.h is not present on real BSD machines
 */
typedef double 	coor_t;
#define INF	(coor_t) MAXTYPE (long)

#else

#define INF	MAXTYPE (coor_t)
typedef int    	coor_t;
#endif /* DOUBLE */

typedef int    	mask_t;
typedef double 	meshCoor_t;

typedef struct tile {
    coor_t xl, xr;
    coor_t bl, br;
    coor_t tl, tr;
    mask_t color;
    int known;             /* 0: not known, -1: known but no significant
		              resistances, >0: bitmask of resis. layers */
    int cnt;
    struct terminal   * terms;
    struct nodePoint  * tlPoints;
    struct nodePoint  * rbPoints;
    struct transistor * tor;
    struct tile * next_tor;
    struct subnode ** cons;	/* used when no res extraction */
} tile_t;

/* The next macro accesses the subnodes of a tile
 * when resistance extraction is off.
 */

#define CONS(tile, i) \
    (((subnode_t *) (tile -> cons + nrOfConductors)) + i);

#endif /* tile_h */
