static char *SccsId = "@(#)slant.c 4.3 (TU-Delft) 04/16/93";
/**********************************************************

Name/Version      : makegln/4.3

Language          : C
Operating system  : UNIX SYSTEM V
Host machine      : HP9000

Author            : N.P. van der Meijs
Creation date     : 15-Mar-1988
Modified by       :
Modification date :


        Delft University of Technology
        Department of Electrical Engineering
        Network Theory Section
        Mekelweg 4 - P.O.Box 5031
        2600 GA DELFT
        The Netherlands

        Phone : 015 - 786234

        COPYRIGHT (C) 1988. All rights reserved.
**********************************************************/
#include "config.h"
#include <stdio.h>
#include "aux/aux.h"
#include "makegln.h"

void testIntersection (x, e1, e2)
coor_t x;
edge_t * e1, * e2;
{
    coor_t d;
    coor_t xi;

    if (e1 -> slope == e2 -> slope) return;
    if (e1 -> xl == -INF || e2 -> xl == -INF) return;

    d = ((e2 -> yl - e1 -> yl) + e2 -> slope * (e1 -> xl - e2 -> xl))
      / (e1 -> slope - e2 -> slope);

    xi = e1 -> xl + d;
    if (xi <= x) return;

    ASSERT (xi > x);

    if (xi <= e1 -> xl || xi >= e1 -> xr) return;
    if (xi <= e2 -> xl || xi >= e2 -> xr) return;

    e1 -> xi = Min (xi, e1 -> xi);
    e2 -> xi = Min (xi, e2 -> xi);

    return;
}

smallerAtX (x, e1, e2)	/* return 1 if e2 <x e1, 0 otherwise */
register coor_t x;
register edge_t * e1, *e2;
{
    ASSERT ((e1 -> xr > x) || (e1 -> bundle == NULL));
    if (e1 -> xl > x || e1 -> xr < x) return (0);
    if (e2 -> xl > x || e2 -> xr < x) return (0);
    /* e1 and e2 are comparable at x */
    if (Y (e2, x) < Y (e1, x))        return (1);
    if (Y (e2, x) > Y (e1, x))        return (0);
    if (e1 -> xr == x)                return (0); /* !!! */
    if (e2 -> slope < e1 -> slope)    return (1);
    return (0);
}

edge_t *
split (e1)	/* split sublist of intersecting edges */
edge_t * e1;
{
    coor_t xi   = e1 -> xi;
    coor_t yi   = Y (e1, xi);
    edge_t * e;
    edge_t * createEdge ();
    edge_t * e2 = e1 -> fwd;
    edge_t * e3 = e1 -> bwd;
    if (e2 -> xi != xi) printEdge ("split", e2);
    ASSERT (e2 -> xi == xi);

    while (e2 -> fwd -> xi == xi
	&& e2 -> fwd -> slope < e2 -> slope)
	e2 = e2 -> fwd;

    /* e2 is other end of sublist */

    for (;;) {
	ASSERT (Y (e1, xi) == yi);
	if (e1 -> xr > xi) {
	    e = createEdge (xi, yi, e1 -> xr, e1 -> yr, e1 -> slope, e1 -> sign);
	    e -> xi = INF, e -> xc = e1 -> xc;
	    e -> bundle = e1 -> bundle, e1 -> bundle = (edge_t *) NULL;
	    /* insert above e3 */
	    e -> fwd = e3 -> fwd, e -> bwd = e3;
	    e3 -> fwd -> bwd = e, e3 -> fwd = e;
	    e1 -> xr = xi, e1 -> yr = yi;
	    e1 -> xi = INF;
	}
	if (e1 == e2) break;
	e1 = e1 -> fwd;
    }
    ASSERT (e3 -> fwd == e);
    return (e3 -> fwd);
}
