#ifndef lint
static char *SccsId = "@(#)edge.c 4.6 (TU-Delft) 4/26/93";
#endif /* lint */
/**********************************************************

Name/Version      : space/4.6

Language          : C
Operating system  : UNIX SYSTEM V
Host machine      : HP9000

Author(s)         : A.J. van Genderen
		  : N.P. van der Meijs
Creation date     : 15-Mar-1988
Modified by       :
Modification date :


        Delft University of Technology
        Department of Electrical Engineering
        Network Theory Section
        Mekelweg 4 - P.O.Box 5031
        2600 GA DELFT
        The Netherlands

        Phone : 015 - 786234

        COPYRIGHT (C) 1988. All rights reserved.
**********************************************************/
#include <stdio.h>
#include "include/config.h"
#include "include/type.h"
#include "aux/aux.h"
#include "scan.h"

static int allocs = 0,
	   frees  = 0,
	   max    = 0;

static edge_t * list = NULL;

edge_t * createEdge (xl, yl, xr, yr, color)
coor_t xl, yl, xr, yr;
mask_t color;
{
    int i;
    static int fit = 0;
    edge_t * edge;

    ASSERT (xl < xr || (xl == INF && xr == INF));

    if (list == NULL) {
        if (fit == 0)
            fit = FIT (sizeof (edge_t), 100);
        list = NEW (edge_t, fit);
        for (i = 0; i < fit - 1; i++)
            (list + i) -> fwd = list + i + 1;
        (list + fit - 1) -> fwd = NULL;
    }

    edge = list;
    list = list -> fwd;

    edge -> xl =  xl, edge -> xr =  xr;
    edge -> yl =  yl, edge -> yr =  yr;
    edge -> color = color;

    edge -> dy = yr - yl;
    edge -> dx = xr - xl;

    edge -> xc =  edge -> xr;
    edge -> xi = INF;

    edge -> bundle = NULL;
    edge -> fwd = edge -> bwd = NULL;
    edge -> tile = NULL;

    if (++allocs - frees > max) max = allocs - frees;

    return (edge);
}

void disposeEdge (edge)		 /* dispose an edge */
edge_t * edge;
{
    frees++;
    edge -> fwd = list;
    list = edge;
}

/*  printEdge - print edge, prefixed by s
*/
void printEdge (s, edge)
char * s;
edge_t * edge;
{
    fprintf (stderr,
	"%s: xl=%g yl=%g xr=%g yr=%g xi=%g xc=%g dy/dx=%g color=%#o\n",
	s, (double) edge -> xl, (double) edge -> yl,
	(double) edge -> xr, (double) edge -> yr,
	(double) edge -> xi, (double) edge -> xc,
	(double) edge -> dy / edge -> dx, edge -> color);
}

void edgeStatistics (fp)
FILE * fp;
{
    fprintf (fp, "\tedges allocated    : %d\n", allocs);
    fprintf (fp, "\tedges freed        : %d\n", frees);
    fprintf (fp, "\tmax edges in core  : %d\n", max);
}
