static char *SccsId = "@(#)mkCapBit.c 4.2 (TU-Delft) 08/28/90";
/**********************************************************

Name/Version      : tecc/4.2

Language          : C
Operating system  : UNIX SYSTEM V
Host machine      : HP9000

Author            : A.J. van Genderen
Creation date     : 10-Oct-1988
Modified by       :
Modification date :


        Delft University of Technology
        Department of Electrical Engineering
        Network Theory Section
        Mekelweg 4 - P.O.Box 5031
        2600 GA DELFT
        The Netherlands

        Phone : 015 - 786234

        COPYRIGHT (C) 1988. All rights reserved.
**********************************************************/
#include <stdio.h>
#include <signal.h>
#include <dmincl.h>
#include "define.h"
#include "type.h"
#include "extern.h"

mkCapBitmasks ()     /* Make the bitmasks for searching the 
			lateral capacitances. 
			Also remove the redundant element conditions
			then.
		      */
{
    int i;
    int bitmask;
    struct layCondRef * cond;
    struct layCondRef * prevcond;

    for (i = 0; i < cap_cnt; i++) {

	caps[i].sBitPresent = 0;
	caps[i].sBitAbsent = 0;
	caps[i].oeBitPresent = 0;
	caps[i].oeBitAbsent = 0;

        cond = caps[i].cond;
	prevcond = NULL;

	while (cond != NULL) {

	    if (cond -> layC -> lay -> occurrence == SURFACE) {

		bitmask = 1;
		bitmask = bitmask << maskTransf[ cond -> layC -> lay -> mask ];

		if (cond -> layC -> present)
		    caps[i].sBitPresent = caps[i].sBitPresent | bitmask;
		else
		    caps[i].sBitAbsent = caps[i].sBitAbsent | bitmask;

		prevcond = cond;
	    }
	    else if (cond -> layC -> lay -> occurrence == OTHEREDGE) {

		bitmask = 1;
		bitmask = bitmask << maskTransf[ cond -> layC -> lay -> mask ];

		if (cond -> layC -> present)
		    caps[i].oeBitPresent = caps[i].oeBitPresent | bitmask;
		else
		    caps[i].oeBitAbsent = caps[i].oeBitAbsent | bitmask;

                /* remove this redundant element condition */

		if (prevcond)
		    prevcond -> next = cond -> next;
		else
		    caps[i].cond = cond -> next;
	    }
	    else {
		prevcond = cond;
	    }

	    cond = cond -> next;
	}
    }
}
