static char *SccsId = "@(#)mkKeys.c 4.3 (TU-Delft) 05/26/92";
/**********************************************************

Name/Version      : tecc/4.3

Language          : C
Operating system  : UNIX SYSTEM V
Host machine      : HP9000

Author            : A.J. van Genderen
Creation date     : 15-Mar-1988
Modified by       :
Modification date :


        Delft University of Technology
        Department of Electrical Engineering
        Network Theory Section
        Mekelweg 4 - P.O.Box 5031
        2600 GA DELFT
        The Netherlands

        Phone : 015 - 786234

        COPYRIGHT (C) 1988. All rights reserved.
**********************************************************/
#include <stdio.h>
#include <signal.h>
#include <dmincl.h>
#include "define.h"
#include "type.h"
#include "extern.h"

int elemtype;
int elemno;

mkKeys ()
{
    elemtype = CON;
    for (elemno = 0; elemno < con_cnt; elemno++) {
	mkElemKeys (0, 1, keylist);
    }

    elemtype = TOR;
    for (elemno = 0; elemno < tor_cnt; elemno++) {
	mkElemKeys (0, 1, keylist);
    }

    for (elemno = 0; elemno < cap_cnt; elemno++) {

	if (caps[ elemno ].nLay -> occurrence == OTHEREDGE) {
	    elemtype = LATCAP;
	}
	else if (caps[ elemno ].pLay -> occurrence == EDGE
	|| (caps[ elemno ].nLay -> mask >= 0
	    && caps[ elemno ].nLay -> occurrence == EDGE)) {
	    elemtype = EDGECAP;
	}
	else {
	    elemtype = SURFCAP;
	}

	mkElemKeys (0, 1, keylist);
    }

    elemtype = RES;
    for (elemno = 0; elemno < res_cnt; elemno++) {
	mkElemKeys (0, 1, keylist);
    }

    elemtype = VDIMEN;
    for (elemno = 0; elemno < vdim_cnt; elemno++) {
	mkElemKeys (0, 1, keylist);
    }

    for (elemno = 0; elemno < shape_cnt; elemno++) {
	if (shps[ elemno ].type == CSHAPE || shps[ elemno ].type == ESHAPE)
	    elemtype = shps[ elemno ].type;
	mkElemKeys (0, 1, keylist);
    }
}

mkElemKeys (keyval, weight, layref)
int keyval;
int weight;
struct layerRef *layref;
{
    struct elemRef *elref;
    struct layCondRef *cond;

    int lrmask = -1;		/* !!! */
    int lroccurrence = -1;
    int condmask = -1;
    int condoccurrence = -1;
    int condpresent = -1;

    int mustBePresent;
    int mustBeAbsent;

    if (layref == NULL) {

	ALLOC (elref, 1, struct elemRef);
	elref -> next = keytab [ keyval ];
	keytab [ keyval ] = elref;
	elref -> type = elemtype;
	elref -> no = elemno;
	elref -> check = 0;

	return;
    }

    switch (elemtype) {
	case CON :
	    cond = cons [ elemno ].cond;
	    break;
	case TOR :
	    cond = tors [ elemno ].cond;
	    break;
	case SURFCAP :
	case EDGECAP :
	case LATCAP :
	    cond = caps [ elemno ].cond;
	    break;
	case RES :
	    cond = ress [ elemno ].cond;
	    break;
	case VDIMEN :
	    cond = vdms [ elemno ].cond;
	    break;
	case ESHAPE :
	case CSHAPE :
	    cond = shps [ elemno ].cond;
	    break;
    }

    while (cond != NULL) {
	if (cond -> layC -> lay -> mask == layref -> lay -> mask
	&& cond -> layC -> lay -> occurrence == layref -> lay -> occurrence) 
	     break;

	cond = cond -> next;
    }

    lrmask = layref -> lay -> mask;
    lroccurrence = layref -> lay -> occurrence;

    if (cond) {
	condmask = cond -> layC -> lay -> mask;
	condoccurrence = cond -> layC -> lay -> occurrence;
	condpresent = cond -> layC -> present;
    }

    mustBePresent = 0;
    mustBeAbsent = 0;
    if (cond != NULL) {
	if (cond -> layC -> present)
	    mustBePresent = 1;
	else
	    mustBeAbsent = 1;
    }

    if ( ! mustBeAbsent ) {
	mkElemKeys (keyval + weight, weight * 2, layref -> next);
    }
    if ( ! mustBePresent ) {
	mkElemKeys (keyval, weight * 2, layref -> next);
    }
}
