static char *SccsId = "@(#)nextAttr.c 4.3 (TU-Delft) 08/11/92";
/**********************************************************

Name/Version      : xsls/4.3

Language          : C
Operating system  : UNIX SYSTEM V
Host machine      : HP9000

Author(s)         : A.J. van Genderen
Creation date     : 16-Feb-1987
Modified by       : S. de Graaf
Modification date : 08-Dec-1987


        Delft University of Technology
        Department of Electrical Engineering
        Network Theory Section
        Mekelweg 4 - P.O.Box 5031
        2600 GA DELFT
        The Netherlands

        Phone : 015 - 786234

        COPYRIGHT (C) 1987 , All rights reserved
**********************************************************/
#include <stdio.h>

/* nextAttr reads attribute string a, 
   puts in p the next parameter, in v the next   
   value, and returns the rest of the attribute 
   string 'a' (uses the part of 'a' that has   
   been read !) 
*/

char *nextAttr (p, v, a)  
char **p;                 
char **v;                 
char *a;                  
{
    char *ret;
    char pc;

    if (a == NULL || *a == '\0') {
	*p = NULL;
	*v = NULL;
	return (NULL);
    }

    *p = a;
    *v = *p + 1;
    pc = 'a';
    while (**v != '\0' && ((**v != '=' && **v != ';') || pc == '\\'))
	pc = *((*v)++);
    if (**v == '\0') {
	ret = NULL;
	*v = NULL;
    }
    else if (**v == ';') {
	**v = '\0';
	ret = *v + 1;
	*v = NULL;
    }
    else {  /* **v == '=' */
	**v = '\0';
        ret = ++(*v);
	pc = 'a';
        while (*ret != '\0' && (*ret != ';' || pc == '\\'))
	    pc = *(ret++);
	if (*ret == '\0')
	    ret = NULL;
	else {
	    *ret = '\0';
	    ret++;
	}
    }
    if (**p == '\0')
	*p = NULL;

    return (ret);
}

/* getAttrIntValue reads attribute string attr,
   searches for parameter par,
   and puts in val the integer value (if there is one).
*/

getAttrIntValue (attr, par, val)
char *attr;
char *par;
int  *val;
{
    char *p;
    char *v;
    char pc;
    int  i;

    while (attr != NULL && *attr != '\0') {
	v = attr + 1;
	pc = 'a';
	while (*v != '\0' && ((*v != '=' && *v != ';') || pc == '\\'))
	    pc = *v++;
	if (*v == '\0') {
	    return;
	}
	else if (*v == ';') {
	    attr = ++v;
	}
	else {  /* *v == '=' */
	    *v = '\0';
	    i = strcmp (attr, par);
	    *v = '=';
	    p = ++v;
	    pc = 'a';
	    while (*v != '\0' && (*v != ';' || pc == '\\'))
		pc = *v++;
	    if (*v == '\0')
		attr = NULL;
	    else {
		*v = '\0';
		attr = v + 1;
	    }
	    if (i == 0 && *p != '\0') {
		sscanf (p, "%d", val);
		if (attr != NULL) *v = ';';
		return;
	    }
	    if (attr != NULL) *v = ';';
	}
    }
}
