/***************************************************************************
 *
 *  INVESTMENT INTELLIGENCE SYSTEMS CORPORATION
 *
 *	simple.c
 *	@(#)simple.c	3.3.1.3 98/09/01
 *
 *	This boundin provides the user with simple boundin template in which
 *	several functions are constructed. The following functions are
 *	availble from Wingz if the boundin is loaded using the GET BOUNDIN
 *	command:
 *
 *	simple:add(x,y)		returns the sum of x and y
 *	simple:mult(x,y)	returns the product of x and y
 *	simple:reverse(s)	returns the string s, reversed
 *
 ***************************************************************************
 */

#if defined(WIN32)
#include <windows.h>
#endif

#define numfuncs        3
#include "Boundin.h"

IATFUNC		mult2args(PVAL, PVAL);
IATFUNC		add2args(PVAL, PVAL);
IATFUNC		rev(PVAL, PVAL);
IATEXITFUNC	ExitFunc(void);

#if defined(WIN32)
BOOL APIENTRY DllMain(HANDLE hModule, DWORD dwReason, LPVOID lpReserved)
{
	return TRUE;
}
#endif

/* BDROUT defines the Wingz/Boundin interface */
BDROUT rout =
{
	numfuncs, XFDEF(ExitFunc),
	{
		{ XFDEF(add2args),	"\003add",		2 | NORMAL},
		{ XFDEF(mult2args),	"\004mult",		2 | NORMAL},
		{ XFDEF(rev),		"\007reverse",	1 | NORMAL}
	}
};

/* Function descriptions (appear in function glossary) */
BDFUNCLIST =
{
	(PCHAR)"Simple Boundin",
	(PCHAR)"add(number1, number2)",
	(PCHAR)"Returns the sum of number1 and number2",
	RETNUMERIC,

	(PCHAR)"Simple Boundin",
	(PCHAR)"mult(number1, number2)",
	(PCHAR)"Returns the product of number1 and number2",
	RETNUMERIC,

	(PCHAR)"Simple Boundin",
	(PCHAR)"reverse(string)",
	(PCHAR)"Returns the reversed string",
	RETNUMERIC,

	0, 0, 0, 0
};


/* Point of entry */
BDMAINFUNC(BoundinCalls * calls)
{
    return &rout;
}


IATFUNC add2args(PVAL pret, PVAL parg)
{
	if (parg[0].flag == NUMERIC && parg[1].flag == NUMERIC)
	{
		/* Add numbers together and return result */
		xfSetLong(pret, parg[0].val.numeric + parg[1].val.numeric);
	}
	else
	{
		/* Argument is bad */
		xfSetErr(pret, ARGBAD);
	}
}

IATFUNC mult2args(PVAL pret, PVAL parg)
{
	if (parg[0].flag == NUMERIC && parg[1].flag == NUMERIC)
	{
		/* Multiply numbers together and return result */
		xfSetLong(pret, parg[0].val.numeric * parg[1].val.numeric);
	}
	else
	{
		/* Argument is bad */
		xfSetErr(pret, ARGBAD);
	}
}

IATFUNC rev(PVAL pret, PVAL parg)
{
	int						i,j;
	static unsigned char	buf[256];

	if (parg[0].flag == STRING)
	{
		/* Reverse string */
		buf[0] = parg[0].val.string[0];

		for (i = parg[0].val.string[0],j = 1; i > 0 ; i--,j++)
			buf[j] = parg[0].val.string[i];

		xfSetString(pret, buf);
	}
	else
	{
		/* Argument is bad */
		xfSetErr(pret, ARGBAD);
	}
}

/* Point of exit */
IATEXITFUNC ExitFunc(void)
{
	/* This function is called when the boundin is removed from memory */
}
