/***************************************************************************
 *						INVESTMENT INTELLIGENCE SYSTEMS CORPORATION
 *
 *									PROPRIETARY DATA
 *
 *		THIS DOCUMENT CONTAINS TRADE SECRET DATA WHICH IS THE PROPERTY OF
 *		INVESTMENT INTELLIGENCE. THIS DOCUMENT IS SUBMITTED TO RECIPIENT IN
 *		CONFIDENCE. INFORMATION CONTAINED HEREIN MAY NOT BE USED, COPIED OR
 *		DISCLOSED IN WHOLE OR IN PART EXCEPT AS PERMITTED BY WRITTEN AGREEMENT
 *		SIGNED BY AN OFFICER OF INVESTMENT INTELLIGENCE SYSTEMS CORPORATION
 *
 *		THIS MATERIAL IS ALSO COPYRIGHTED AS AN UNPUBLISHED WORK UNDER
 *		SECTIONS 104 AND 408 OF TITLE 17 OF THE UNITED STATES CODE.
 *		UNAUTHORIZED USE, COPYING OR OTHER REPRODUCTION IS PROHIBITED BY LAW.
 *
 *		Title:	WZListen.h
 *		Sccsid:	@(#)WZListen.h	3.3.1.3	09/29/98	10:54:22
 *		Author:	Phil Shotton
 *		Created:	Wed 26 Mar 18:12:45 1997
 *
 ***************************************************************************/

#ifndef _WZLISTEN_H
#define _WZLISTEN_H


#define TT_COMMPORT 	"6666"
#define WZ_MAGIC "WZ3ID"
#define TT_MAXCMD_LEN 	(1024*8)

#if defined(MAINPROG)
#define TT_ALLOW_COMMANDS

#define TT_SENDEVENT


#define TT_MAXCMDS 	5
#define TT_COMEVENT 	"CmDeVeNt"

#define STDIN 0

#define MAX_HOSTNAME_SZE 200
#define MAX_EVENTNAME_SZE 200
#define MAX_CONNS 20

#define xfssCommand        (*hstools_callbacks->ssCommand)
#define xfssRunEvent        (*hstools_callbacks->ssRunEvent)

typedef struct TCS
{
    char hostname[MAX_HOSTNAME_SZE+1];
    char eventname[MAX_EVENTNAME_SZE+1];
    char buff[TT_MAXCMD_LEN + 1];
    long addr;
    int port;
    int fd;
    int numcons;
    int status;
    int lsterr;
    int xid;
    int bidx;
} TT_CONSTR, * TT_CONSTRP, ** TT_CONSTRPP ;

/* error code #define's */
#define TT_NOERROR	(-1000)
#define TT_CONNCLOSED	(-1001)
#define TT_NOMEM 	(-1002)
#define TT_NOSVC 	(-1003)
#define TT_NOSOCK 	(-1004)
#define TT_SOCKERR	(-1005)
#define TT_NOHOST	(-1006)
#define TT_NOCONN	(-1007)
#define TT_INTERNAL	(-1008)
#define TT_BADARG	(-1009)
#define TT_NOBIND	(-1010)
#define TT_NOLIST	(-1011)
#define TT_LASTERROR	TT_NOLIST

char * TT_ERRORMSG[] = 
{
    "No Error",
    "Connection Closed",
    "No Memory",
    "No Service",
    "No Socket",
    "Socket Error",
    "No Host",
    "No Connection",
    "Internal Error",
    "Bad Argument",
    "Bind Error",
    "Not a Listen Socket",
    ""
};

/* status code #define's */
#define TT_DISCONNECTED 	(0)
#define TT_CONNECTED		(1)
#define TT_NOTCONNECTED 	(2)
#define TT_LISTWAIT	 	(3)
#define TT_CONNWAIT		(4)
#define TT_IDENTIFY		(5)

#define TT_CONNECT	1
#define TT_LISTEN	2

typedef struct ADDR 
{
    struct ADDR * nxt;
    struct ADDR * prv;
    unsigned long addr;
    char * name;
} HOST, *PHOST;

typedef struct
{
    int uid;
    int gid;
    char * password;
    PHOST hosts;
    int hnum;
} SECURE, * PSECURE;


/* Functions from WZListen.c */
void BoundinInit(HSTxfFuncs *xffuncs, HSTCallbacks *callbacks, BoundinCalls *calls) ;
void InitFunc(PVAL pret, PVAL parg) ;
void callback(void * clientdata, INT * fdp, INPUTID * idp) ;
void ExitFunc(PVAL pret, PVAL parg) ;
void Password(PVAL pret,PVAL parg);
void Mode(PVAL pret,PVAL parg) ;
void Hosts(PVAL pret,PVAL parg) ;
int delhost(char * host) ;
int addhost(char * host) ;
int tt_listen(char * port, int numcons, char * eventname) ;
int tt_accept(int connection,char * eventname) ;
int tt_read(int connection, char * result, int count, char * termchars, int tcnt) ;
char * decode(char * data) ;
char * tt_errstr(int t) ;
void tt_do_int_command(int conidx,TT_CONSTRP connp) ;
int auth_ok(char * buff, TT_CONSTRP connp) ;
int add_conn(TT_CONSTRP connp, char * hostname, char * eventname) ;
void del_conn(TT_CONSTRP connp);
int find_conn(int idx, TT_CONSTRPP connp) ;
int isallnum(char * name) ;

#endif /* MAINPROG */
#endif /* _WZLISTEN_H */
