#!/bin/sh
#
# @(#)wzinfo	3.3.1.4 98/09/09
# Wingz 3 info script
#
# Usage: wzinfo [-p platform]
#

fatal()
{
    echo fatal: $*
    exit 1
}

usage()
{
    echo "usage: wzinfo [-p platform]"
    exit 2
}

test -n "$WINGZ3" || fatal "Environment variable 'WINGZ3' not set"
test -d "$WINGZ3" || fatal "Environment variable 'WINGZ3' not a directory"

. $WINGZ3/bin/wzenv

PLATFORM=
if [ "$1" = "-p" ]
then
    test $# = 2 || usage
    PLATFORM=$2
    shift 2
    test -d $WINGZ3/pkginfo/$PLATFORM || fatal "no packages for the $PLATFORM platform"
fi

test $# = 0 || usage

if [ -z "$PLATFORM" ]
then
    PLATFORM=`cd $WINGZ3/pkginfo; echo [A-Z]*`
fi

for p in $PLATFORM
do
    echo
    echo Packages installed for $p:
    echo
    for f in $WINGZ3/pkginfo/$p/*.list
    do
	name=`awk -F= '/^i NAME/ { print $2 }' $f`
	version=`awk -F= '/^i VERSION/ { print $2 }' $f`
	complete=
	grep '^i COMPLETE' $f >/dev/null 2>&1
	test $? = 0 || complete="(partial installation)"
	echo "    $name $version $complete"
    done
done
