/***************************************************************************
 *
 *                INVESTMENT INTELLIGENCE SYSTEMS CORPORATION
 *
 *                            PROPRIETARY DATA
 *
 *      THIS DOCUMENT CONTAINS TRADE SECRET DATA WHICH IS THE PROPERTY OF 
 *      INVESTMENT INTELLIGENCE SYSTEMS CORPORATION.
 *      THIS DOCUMENT IS SUBMITTED TO RECIPIENT IN
 *      CONFIDENCE.  INFORMATION CONTAINED HEREIN MAY NOT BE USED, COPIED OR 
 *      DISCLOSED IN WHOLE OR IN PART EXCEPT AS PERMITTED BY WRITTEN AGREEMENT 
 *      SIGNED BY AN OFFICER OF INVESTMENT INTELLIGENCE SYSTEMS CORPORATION
 *
 *      THIS MATERIAL IS ALSO COPYRIGHTED AS AN UNPUBLISHED WORK UNDER
 *      SECTIONS 104 AND 408 OF TITLE 17 OF THE UNITED STATES CODE. 
 *      UNAUTHORIZED USE, COPYING OR OTHER REPRODUCTION IS PROHIBITED BY LAW.
 *
 *      Title:   Boundin.h
 *      Sccsid:  @(#)Boundin.h	3.3.1.40 98/09/07
 *      Author:  Phil Shotton
 *      Created: Wed Sep 2 11:31:39 CDT 1992
 *
 ***************************************************************************
 */

#ifndef __BOUNDIN_INCLUDED
#define __BOUNDIN_INCLUDED

#include <sys/types.h>
#include <sys/time.h>

#ifdef __cplusplus
extern "C" {
#endif

#define XF_VERSION  0x0310

#ifndef numfuncs
#define numfuncs    1
#endif

typedef struct _RELT          /* Routine list element */
{
    void    (*pfunc)();       /* Pointer to function  */
    char    *name;            /* Routine name         */
    short   narg;             /* Number of arguments  */
} RELT, *PRELT;

typedef struct _ROUT          /* Routine list              */
{
    short   nrout;            /* Number of routines        */
    void    (*exitfunc)();    /* Func pntr to exit routine */
    RELT    relts[numfuncs];  /* Func pntr to routine      */
} ROUT, *PROUT;

typedef struct _BDRELT        /* Routine list element */
{
    char    *fname;           /* Function name        */
    char    *name;            /* Routine name         */
    short   narg;             /* Number of arguments  */
} BDRELT, *PBDRELT;

typedef struct _BDROUT        /* Routine list              */
{
    short   nrout;            /* Number of routines        */
    char    *exitfunc;        /* Func name to exit routine */
    BDRELT  relts[numfuncs];  /* Func pntr to routine      */
} BDROUT, *PBDROUT;

    /* values for function type */
#define MASKOFFTYPE    0x00FF
#define XFRAWCHARSET   0x2000

    /* extra function type only for boundins */
#define VARARGS        0x0800
#define TERMVAL        10        /* for terminating vararg list */
#define NULLVAL        TERMVAL   /* for backward compat. */

#if !defined(WZ_INTERNAL)

#define ROUT  BDROUT
#define PROUT PBDROUT

#ifndef PROTOVOID
#if defined(__cplusplus)
#define PROTOVOID
#else
#define PROTOVOID VOID
#endif
#endif

#ifndef PROTO
#ifdef NOPROTO
#define PROTO(A) ()
#else
#define PROTO(A) A
#endif
#endif

#define FALSE 0
#define TRUE  1

#define GLOBAL
#define FUNCTION
#define PUBLIC
#define FAST       register
#define STATIC     static
#define LOCAL
#define EXTERN     extern
#define PASCAL
#define EXPORTFUNC

typedef unsigned char   BYTE, *PBYTE, **PPBYTE;
typedef void            VOID, *PVOID;
typedef short           BOOL, *PBOOL;
typedef unsigned char   STR, *PSTR;
typedef unsigned char   CHAR, *PCHAR;
typedef int             INT, *PINT;
typedef unsigned int    USINT, *PUSINT;
typedef short           SHORT, *PSHORT;
typedef unsigned short  USHORT, *PUSHORT;
typedef long            LONG, *PLONG;
typedef unsigned long   ULONG, *PULONG;
typedef double          DOUBLE, *PDOUBLE;

    /* Portable ROUT function specification - need text for a boundin */
#if defined(__STDC__)
#define XFDEF(A)        #A
#else
#define XFDEF(A)        "A"
#endif

    /* flag values for arguments and returns */
#define NUMERIC        0
#define STRING         1
#define ERR            2
#define ARRAY          6
#define ALLOCSTRING    8     /* for old-style boundins */
#define DFLTVAL        11    /* for the default value */

    /* flags values for external functions return types */
#define RETUNKNOWN     0
#define RETNUMERIC     1
#define RETSTRING      2
#define RETERROR       4
#define RETARRAY       8

    /* For declaring well known external functions */
#define BDFUNCLIST     PUBLIC EXT_FUNCS ext_funcs[]

    /* extended flags values */
#define EXTISBLANK     0x01  /* VAL came from a blank cell */

    /* values for function type */
#define VARIABLE       0x0100
#define NORMAL         0x0400
#define CONSTANT       0x1000
#define ONDEMAND       0x4000
#define CIRCULAR       0x8000

    /* values for error types */
#define BADARGS            3    /* Incorrect number of arguments */
#define BADSYNTAX          4    /* Invalid syntax */
#define DERIVED_ERR        5    /* Reference err */
#define LOOKUPFAILED       6    /* Lookup Failed */
#define REFERR             7    /* Reference error */
#define INSUFDATA          8    /* Insufficient data */
#define DIVZERO            9    /* Division by zero is not allowed */
#define TOOCOMPLEX        11    /* Formula is too complex */
#define ARGBAD            12    /* Argument is inappropriate */
#define MISSINGWS         13    /* No worksheet */
#define REMOTENA          15    /* Remote data is not available */
#define BADARRAY          17    /* Invalid array syntax */
#define BADDATE           18    /* Inappropriate date value */
#define BADTIME           19    /* Inappropriate time value */
#define NOMEM             21    /* Not enough memory */
#define USRERR            26    /* User error */
#define BADINDEX          30    /* Array index is beyond number of dimensions */
#define WRONGDIMS         32    /* Wrong number of dimensions */
#define NOTARRAY          33    /* Variable is not an array */
#define BADARRAYSIZE      34    /* Array is not allowed in this context */
#define FUNCUNAVAILABLE   35    /* Function is not available */
#define BADFUNCNAME       59    /* Bad function name */
#define BADIMPFUNC        61    /* Bad Imported function */

typedef struct _val
{
    union
    {
        short         err;           /* error argument or return*/
        double        numeric;       /* numeric argument or return */
        unsigned char *string;       /* text argument or return*/
        unsigned long wzprivate[4];  /* private Wingz information*/

        struct
        {
            struct ele       *eles;  /* pointer to elements */
            unsigned char    ref;    /* unused in externals */
            unsigned char    dims;   /* number of dimensions in array [1,2,3] */
            unsigned short   d1;     /* number of elements in dimension 1 */
            unsigned short   d2;     /* number of elements in dimension 2 */
            unsigned short   d3;     /* number of elements in dimension 3 */
        } array;

    } val;

    short    flag;                   /* type of argument or return */
    short    extflag;                /* extended flags for argument */
    long     cprivate3;              /* private Wingz information */

} VAL, *PVAL;

    /* conveniance functions */
#define xfSetErr(P, E)      do { (P)->flag = ERR; \
                                 (P)->val.err = (E); } while (0)
#define xfSetLong(P, L)     do { (P)->flag = NUMERIC; \
                                 (P)->val.numeric = (DOUBLE)(L); } while (0)
#define xfSetDouble(P, D)   do { (P)->flag = NUMERIC; \
                                 (P)->val.numeric = (D); } while (0)
#define xfSetString(P, S)   do { (P)->flag = STRING; \
                                 (P)->val.string = (unsigned char*) (S); \
                               } while (0)
#define p2ccopy             (*hstools_xffuncs->P2CCopy)
#define c2pcopy             (*hstools_xffuncs->C2PCopy)
#define ustrcat             (*hstools_xffuncs->UStrCat)
#define ustrncat            (*hstools_xffuncs->UStrNCat)
#define ustrcmp             (*hstools_xffuncs->UStrCmp)
#define ustrcpy(D,S)        (VOID)memmove((char*)(D), \
                                          (char*)(S), ((size_t)((S[0]+1))))
#define ustrncpy            (*hstools_xffuncs->UStrNCpy)

    /* array handling functions */
#define xfNewArray          (*hstools_xffuncs->NewArray)
#define xfSetArrayEl        (*hstools_xffuncs->SetArrayEl)
#define xfSetArrayNumEl     (*hstools_xffuncs->SetArrayNumEl)
#define xfSetArrayStrEl     (*hstools_xffuncs->SetArrayStrEl)
#define xfGetArrayEl        (*hstools_xffuncs->GetArrayEl)
#define xfFreeArray         (*hstools_xffuncs->FreeArray)
#define xfCheckArrayIndex   (*hstools_xffuncs->CheckArrayIndex)

    /* date handling functions */
#define xfDaysToDmy         (*hstools_xffuncs->Days_To_Dmy)
#define xfDmyToDays         (*hstools_xffuncs->Dmy_To_Days)

    /* generic specials */
#define xfAddInput          (*hstools_xffuncs->AddInput)
#define xfRemoveInput       (*hstools_xffuncs->RemoveInput)
#define xfSetTimedFunc      (*hstools_xffuncs->SetTimedFunc)
#define xfRemoveTimedFunc   (*hstools_xffuncs->RemoveTimedFunc)

    /* boundin specials */
#define xfNoMoreMemory      (*hstools_xffuncs->NoMoreMemory)
#define xfEnvFromWingz      (*hstools_xffuncs->EnvFromWingz)
#define xfWingzFromEnv      (*hstools_xffuncs->WingzFromEnv)
#define xfGetLastCellErr    (*hstools_xffuncs->GetLastCellErr)
#define xfShouldAbort       (*hstools_xffuncs->ShouldAbort)

    /* shared library specials - for boundins loading boundins */
#define xfExternalHandle    (*hstools_xffuncs->ExternalHandle)
#define xfDLOpen            (*hstools_xffuncs->DLOpen)
#define xfDLSym             (*hstools_xffuncs->DLSym)
#define xfDLClose           (*hstools_xffuncs->DLClose)
#define xfDLError           (*hstools_xffuncs->DLError)

    /* generic version info */
#define IATinterfaceVersion (hstools_xffuncs->IATStructVer)
#define IATproductID        (hstools_xffuncs->IATprodID)
#define IATversionNumber    (*hstools_xffuncs->IATversionNum)

    /* unix special - get top level widget */
#define IATtopLevel         (hstools_xffuncs->IATtop)

typedef PVOID                    WSID;
typedef SHORT                    NMID;
typedef LONG                     INPUTID;
typedef SHORT                    RCNR;

#endif /* !WZ_INTERNAL */

    /* These must match the sytems XtInput...Mask in Intrinsic.h */
#define INPUT_MASK_READ          1
#define INPUT_MASK_WRITE         2
#define INPUT_MASK_EXCEPTION     4

#define INVALID_INPUTID          (-1)

    /* types of event to observe */
#define OBSTYPE_DATA             0x01
#define OBSTYPE_FORMAT           0x02
#define OBSTYPE_FORMULA          0x04
#define OBSTYPE_SHEET            0x08
#define OBSTYPE_ALL              0xFF

    /* types of event that can happen to observed cells */
#define OBSEVENT_NONE            0
#define OBSEVENT_ERROR           1
#define OBSEVENT_CELLCLEAR       2
#define OBSEVENT_DATAMODIFIED    3
#define OBSEVENT_FORMATCHANGED   4
#define OBSEVENT_NEWFORMULA      5
#define OBSEVENT_FORMULACLEARED  6
#define OBSEVENT_FORGETCELLS     7
#define OBSEVENT_FORGETSHEET     8
#define OBSEVENT_HORIZDEL        9
#define OBSEVENT_VERTDEL         10
#define OBSEVENT_HORIZINS        11
#define OBSEVENT_VERTINS         12
#define OBSEVENT_ROWSIZED        13
#define OBSEVENT_COLSIZED        14

#define OBSID_ERROR              (-1)
#define OBSID_USED               (-1)

#define VALIDATEID_ERROR         (-1)
#define VALIDATEID_USED          (-1)

#define INVALID_WSID             ((PWS)0)
#define WSFLAGS_NONE             0
#define WSFLAGS_HIDDEN           1

#define NOSHEET                  (-1)
#define CURSHEET                 (-2)

typedef LONG                     OBSID;
typedef LONG                     VALIDATEID;

typedef struct
{
   NMID    ss;
   RCNR    row;
   RCNR    col;
} SHRC, *PSHRC;

typedef struct
{
    WSID   ws;
    INT    obstype;
    USINT  num_cells;
    SHRC   cells[1];
} OBSBLK, *POBSBLK;

    /* observer callback function types */
typedef VOID (*POBSCALLBACK) PROTO((OBSID, POBSBLK, PVOID));
typedef BOOL (*PVALIDATECALLBACK) PROTO((OBSID, PVAL, PVOID));

    /* add input and timer callback function types */
typedef VOID (*CALLBACKFUNC) PROTO((VOID*, INT*, INPUTID*));
typedef VOID (*TIMEDFUNC) PROTO((VOID*, VOID*));

#define RTHILITE_NONE   (1)
#define RTHILITE_SIMPLE (2)
#define RTHILITE_CELL   (3)
#define RTHILITE_TEXT   (4)

    /* this is just for highlight information */
typedef struct RtHiliteStruct
{
    DOUBLE  colour;
    SHORT   type;         /* RTHILITE_NONE, RTHILITE_SIMPLE, */
                          /* RTHILITE_CELL or RTHILITE_TEXT  */
} RtHilite;

#define BOUNDIN_PREFIX "\010boundin%"
#define SERVER_PREFIX  "\007server%"

    /* old style boundin ROUT replacement - deprecated */
typedef struct
{
    char    *fname;       /* function name as known to HST */
    int     nargs;        /* number of args */
    char    *intfname;    /* function name within module */
} KNOWN_BOUNDINS;

typedef struct
{
    PCHAR   catagory;     /* Function Catagory */
    PCHAR   syntax;       /* Function Syntax */
    PCHAR   description;  /* Function Description */
    INT     rettype;      /* Function Return Type */
} EXT_FUNCS;

typedef struct
{
    PCHAR   name;
    LONG    color;
    LONG    style;
    LONG    size;
} CFONT, *PCFONT;

typedef struct
{
    LONG    fillBG;
    CFONT   font;
    LONG    align;
    LONG    attributes;
} CSTYLE, *PCSTYLE;

typedef struct
{
    VOID     (*StartRecalc) PROTO((PSTR));
    VOID     (*EndRecalc) PROTO((PSTR));
    VOID     (*IdleFunc) PROTO((PROTOVOID));
    VOID     (*CheckRegisteredCells) PROTO((PSTR));
    VOID     (*ForgetCell) PROTO((PSTR, BOOL));
    VOID     (*ForgetSheet) PROTO((PSTR));
    RtHilite (*IsHighlighted) PROTO((PSTR, time_t));
    VOID     (*UpdateCell) PROTO((PSTR, PVAL));
} BoundinCalls;

typedef struct
{
    BOOL    (*NewArray) PROTO((PVAL, USHORT, PUSHORT));
    BOOL    (*SetArrayEl) PROTO((PVAL, PUSHORT, PVAL));
    BOOL    (*SetArrayNumEl) PROTO((PVAL, PUSHORT, PDOUBLE));
    BOOL    (*SetArrayStrEl) PROTO((PVAL, PUSHORT, PSTR));
    BOOL    (*GetArrayEl) PROTO((PVAL, PUSHORT, PVAL));
    VOID    (*FreeArray) PROTO ((PVAL));
    BOOL    (*CheckArrayIndex) PROTO((PVAL, PUSHORT));
    VOID    (*SetString) PROTO((PVAL, PSTR));
    INPUTID (*SetTimedFunc) PROTO((TIMEDFUNC, struct timeval*, VOID*));
    VOID    (*NoMoreMemory) PROTO((PROTOVOID));
    PSTR    (*EnvFromWingz) PROTO((PSTR));
    PSTR    (*WingzFromEnv) PROTO((PSTR));
    USHORT  (*GetLastCellErr) PROTO((PROTOVOID));
    INPUTID (*AddInput) PROTO((INT, INT, CALLBACKFUNC, VOID*));
    VOID    (*RemoveInput) PROTO((INPUTID));
    PCHAR   (*P2CCopy) PROTO((PSTR, PCHAR));
    PSTR    (*C2PCopy) PROTO((PCHAR, PSTR));
    USHORT  (*UStrCat) PROTO((PSTR, PSTR));
    USHORT  (*UStrNCat) PROTO((PSTR, PSTR, USHORT));
    SHORT   (*UStrCmp) PROTO((PSTR, PSTR));
    USHORT  (*UStrNCpy) PROTO((PSTR, PSTR, USHORT));
    PVOID   (*DLOpen) PROTO((PCHAR));
    PVOID   (*DLSym) PROTO((VOID*, PCHAR));
    INT     (*DLClose) PROTO((VOID*));
    PCHAR   (*DLError) PROTO((PROTOVOID));
    PVOID   (*ExternalHandle) PROTO((PCHAR));
    VOID    (*RemoveTimedFunc) PROTO((INPUTID));
    SHORT   IATStructVer;
    PSTR    IATprodID;
    DOUBLE  *IATversionNum;
    PVOID   IATtop;
    VOID    (*Days_To_Dmy) PROTO((PDOUBLE, PINT, PINT, PINT));
    LONG    (*Dmy_To_Days) PROTO((INT, INT, INT));
    BOOL    (*ShouldAbort) PROTO((PROTOVOID));
} HSTxfFuncs;

typedef struct
{
    BOOL       (*ssFetchCell) PROTO((PCHAR, PVAL));
    BOOL       (*ssPartialRecalc) PROTO((PSTR));
    BOOL       (*ssNeedsRecalc) PROTO((PSTR));
    BOOL       (*ssAutoCalc) PROTO((PSTR));
    VOID       (*ssMarkIt) PROTO((PSTR));
    VOID       (*ssForceRepaint) PROTO((PSTR));
    VOID       (*ssRecalcIt) PROTO((PROTOVOID));
    BOOL       (*ssRecalcActive) PROTO((PROTOVOID));
    VOID       (*ssBuildDependancies) PROTO((PROTOVOID));
    VOID       (*ssRunEvent) PROTO((PSTR));
    VOID       (*ssCommand) PROTO((PCHAR));
    BOOL       (*ssIsRealTime) PROTO((PROTOVOID));
    OBSID      (*ssObserve) PROTO((WSID, NMID, NMID, RCNR, RCNR, RCNR, RCNR,
                                   INT, POBSCALLBACK, PVOID));
    VALIDATEID (*ssValidate) PROTO((WSID, NMID, RCNR, RCNR,
                                    PVALIDATECALLBACK, PVOID));
    VOID       (*ssObsRm) PROTO((OBSID));
    VOID       (*ssValRm) PROTO((VALIDATEID));
    PCHAR      (*ssGetCell) PROTO((PVAL, PVOID, NMID, RCNR, RCNR));
    BOOL       (*ssPutCell) PROTO((PCHAR, PVOID, NMID, RCNR, RCNR));
    WSID       (*ssNewBook) PROTO((PSTR, INT, PINT));
    WSID       (*ssOpenBook) PROTO((PSTR, INT, PINT));
    NMID       (*ssGetSheetID) PROTO((WSID, PSTR));
    PCHAR      (*ssGetFormula) PROTO((PVOID, NMID, RCNR, RCNR));
    BOOL       (*ssGetStyle) (PCSTYLE, PVOID, NMID, RCNR, RCNR);
    BOOL       (*ssSetStyle) (PCSTYLE, PVOID, NMID, RCNR, RCNR);
    LONG       (*ssGetRCSize) (BOOL, PVOID, NMID, RCNR);
    BOOL       (*ssSetRCSize) (BOOL, PVOID, NMID, RCNR, LONG);
    SHORT      (*ssSetMsgDisplay) (SHORT);
} HSTCallbacks;

#if !defined(WZ_INTERNAL)

    /* Spreadsheet interface functions */
#define wzFetchCell           (*hstools_callbacks->ssFetchCell)
#define wzPartialRecalc       (*hstools_callbacks->ssPartialRecalc)
#define wzNeedsRecalc         (*hstools_callbacks->ssNeedsRecalc)
#define wzAutoCalc            (*hstools_callbacks->ssAutoCalc)
#define wzMarkIt              (*hstools_callbacks->ssMarkIt)
#define wzForceRepaint        (*hstools_callbacks->ssForceRepaint)
#define wzRecalcIt            (*hstools_callbacks->ssRecalcIt)
#define wzRecalcActive        (*hstools_callbacks->ssRecalcActive)
#define wzBuildDependancies   (*hstools_callbacks->ssBuildDependancies)
#define wzRunEvent            (*hstools_callbacks->ssRunEvent)
#define wzCommand             (*hstools_callbacks->ssCommand)
#define wzIsRealTime          (*hstools_callbacks->ssIsRealTime)
#define wzObserve             (*hstools_callbacks->ssObserve)
#define wzValidate            (*hstools_callbacks->ssValidate)
#define wzObsRm               (*hstools_callbacks->ssObsRm)
#define wzValRm               (*hstools_callbacks->ssValRm)
#define wzGetCell             (*hstools_callbacks->ssGetCell)
#define wzPutCell             (*hstools_callbacks->ssPutCell)
#define wzNewBook             (*hstools_callbacks->ssNewBook)
#define wzOpenBook            (*hstools_callbacks->ssOpenBook)
#define wzGetSheetID          (*hstools_callbacks->ssGetSheetID)
#define wzGetFormula          (*hstools_callbacks->ssGetFormula)
#define wzGetStyle            (*hstools_callbacks->ssGetStyle)
#define wzSetStyle            (*hstools_callbacks->ssSetStyle)
#define wzGetRCSize           (*hstools_callbacks->ssGetRCSize)
#define wzSetRCSize           (*hstools_callbacks->ssSetRCSize)
#define wzSetMsgDisplay       (*hstools_callbacks->ssSetMsgDisplay)

EXTERN HSTxfFuncs   *hstools_xffuncs;
EXTERN HSTCallbacks *hstools_callbacks;

#define IATFUNC               VOID
#define IATEXITFUNC           VOID
#define INIT_XF_FUNCS(A)      hstools_xffuncs = (A);
#define INIT_WZ_FUNCS(A)      hstools_callbacks = (A);

#ifdef NOPROTO
#define BDMAINFUNC(C)         HSTxfFuncs *hstools_xffuncs; \
                              HSTCallbacks *hstools_callbacks; \
                              PBDROUT BDMain(); \
                              STATIC PBDROUT BDMain2(); \
                              PBDROUT BDMain(A,B,C) \
                              HSTxfFuncs *A; \
                              HSTCallbacks *B; \
                              BoundinCalls *C; \
                              { \
                                 INIT_XF_FUNCS(A); \
                                 INIT_WZ_FUNCS(B); \
                                 return BDMain2(C); \
                              } \
                              STATIC PBDROUT BDMain2(C)
#else
#ifdef __cplusplus
#define BDMAINFUNC(C)         HSTxfFuncs *hstools_xffuncs; \
                              HSTCallbacks *hstools_callbacks; \
                              extern "C" { \
                              PBDROUT BDMain(HSTxfFuncs*, \
                                             HSTCallbacks*,BoundinCalls*); \
                              STATIC PBDROUT BDMain2(BoundinCalls*); \
                              } \
                              PBDROUT BDMain(HSTxfFuncs*A, \
                                             HSTCallbacks*B, \
                                             BoundinCalls*calls) \
                              { \
                                 INIT_XF_FUNCS(A); \
                                 INIT_WZ_FUNCS(B); \
                                 return BDMain2(calls); \
                              } \
                              STATIC PBDROUT BDMain2(C)
#else
#define BDMAINFUNC(C)         HSTxfFuncs *hstools_xffuncs; \
                              HSTCallbacks *hstools_callbacks; \
                              PBDROUT BDMain(HSTxfFuncs*, \
                                             HSTCallbacks*,BoundinCalls*); \
                              STATIC PBDROUT BDMain2(BoundinCalls*); \
                              PBDROUT BDMain(HSTxfFuncs*A, \
                                             HSTCallbacks*B, \
                                             BoundinCalls*calls) \
                              { \
                                 INIT_XF_FUNCS(A); \
                                 INIT_WZ_FUNCS(B); \
                                 return BDMain2(calls); \
                              } \
                              STATIC PBDROUT BDMain2(C)
#endif /* __cplusplus */
#endif /* NOPROTO */


#endif /* !WZ_INTERNAL */

#ifdef __cplusplus
}
#endif

#endif /* __BOUNDIN_INCLUDED */
