/***************************************************************************
 *
 *                         INFORMIX SOFTWARE, INC.
 *
 *                            PROPRIETARY DATA
 *
 *      THIS DOCUMENT CONTAINS TRADE SECRET DATA WHICH IS THE PROPERTY OF 
 *      INFORMIX SOFTWARE, INC.  THIS DOCUMENT IS SUBMITTED TO RECIPIENT IN
 *      CONFIDENCE.  INFORMATION CONTAINED HEREIN MAY NOT BE USED, COPIED OR 
 *      DISCLOSED IN WHOLE OR IN PART EXCEPT AS PERMITTED BY WRITTEN AGREEMENT 
 *      SIGNED BY AN OFFICER OF INFORMIX SOFTWARE, INC.
 *
 *      THIS MATERIAL IS ALSO COPYRIGHTED AS AN UNPUBLISHED WORK UNDER
 *      SECTIONS 104 AND 408 OF TITLE 17 OF THE UNITED STATES CODE. 
 *      UNAUTHORIZED USE, COPYING OR OTHER REPRODUCTION IS PROHIBITED BY LAW.
 *
 *      Title:   IATTools.h
 *      Sccsid:  @(#)IATTools.h	3.3.1.4     05/03/98     17:45:24
 *      Author:  Richard Bartel
 *      Created: Wed Sep 2 11:31:39 CDT 1992
 *
 ***************************************************************************
 */

#ifndef __IATTOOLS_INCLUDED
#define __IATTOOLS_INCLUDED

#ifdef __cplusplus
extern "C" {
#endif

#ifndef numfuncs
#define numfuncs    1
#endif

typedef struct _RELT        /* Routine list element */
{
    void    (*pfunc)();     /* Pointer to routine   */
    char    *name;          /* Routine name         */
    short   narg;           /* Number of arguments  */
} RELT, *PRELT;

typedef struct _ROUT           /* Routine list              */
{
    short    nrout;            /* Number of routines        */
    void     (*exitfunc)();    /* Func pntr to exit routine */
    RELT     relts[numfuncs];  /* Func pntr to routine      */
} ROUT, *PROUT;

/* Portable ROUT function specification */
#define XFDEF(A)     (A)

/* values for function type */
#define MASKOFFTYPE    0x00FF
#define XFRAWCHARSET   0x2000

#if ! defined(WZ_INTERNAL)

#ifndef PROTO
#ifdef NOPROTO
#define PROTO(A) ()
#else
#define PROTO(A) A
#endif
#endif

#define FALSE 0
#define TRUE  1

#define GLOBAL
#define FUNCTION
#define PUBLIC
#define FAST       register
#define STATIC     static
#define LOCAL
#define EXTERN     extern
#define PASCAL
#define FAR
#define EXPORTFUNC

typedef void            VOID, *PVOID;
typedef short           BOOL, *PBOOL;
typedef unsigned char   STR, *PSTR;
typedef unsigned char   CHAR, *PCHAR;
typedef int             INT, *PINT;
typedef unsigned int    USINT, *PUSINT;
typedef short           SHORT, *PSHORT;
typedef unsigned short  USHORT, *PUSHORT;
typedef long            LONG, *PLONG;
typedef unsigned long   ULONG, *PULONG;
typedef double          DOUBLE, *PDOUBLE;

#define IATFUNC       VOID
#define IATMAINFUNC   PROUT iat_main
#define IATEXITFUNC   VOID

/* flag values for arguments and returns */
#define NUMERIC     0
#define STRING      1
#define ERR         2
#define ARRAY       6

/* values for function type */
#define VARIABLE       0x0100
#define NORMAL         0x0400
#define CONSTANT       0x1000
#define ONDEMAND       0x4000
#define CIRCULAR       0x8000

/* values for error types */
#define BADARGS            3    /* Incorrect number of arguments */
#define BADSYNTAX          4    /* Invalid syntax */
#define LOOKUPFAILED       6    /* Lookup Failed */
#define REFERR             7    /* Reference error */
#define INSUFDATA          8    /* Insufficient data */
#define DIVZERO            9    /* Division by zero is not allowed */
#define TOOCOMPLEX        11    /* Formula is too complex */
#define ARGBAD            12    /* Argument is inappropriate */
#define REMOTENA          15    /* Remote data is not available */
#define BADARRAY          17    /* Invalid array syntax */
#define BADDATE           18    /* Inappropriate date value */
#define BADTIME           19    /* Inappropriate time value */
#define NOMEM             21    /* Not enough memory */
#define USRERR            26    /* User error */
#define BADINDEX          30    /* Array index is beyond number of dimensions */
#define WRONGDIMS         32    /* Wrong number of dimensions */
#define NOTARRAY          33    /* Variable is not an array */
#define BADARRAYSIZE      34    /* Array is not allowed in this context */
#define FUNCUNAVAILABLE   35    /* Function is not available */
#define BADFUNCNAME       59    /* Bad function name */
#define BADIMPFUNC        61    /* Bad Imported function */

typedef struct _val
{
    union
    {
        short         err;           /* error argument or return*/
        double        numeric;       /* numeric argument or return */
        char          *string;       /* text argument or return*/
        unsigned long private[3];    /* private Wingz information*/

        struct
        {
            struct ele       *eles;  /* pointer to elements */
            unsigned char    ref;    /* unused in externals */
            unsigned char    dims;   /* number of dimensions in array [1,2,3] */
            unsigned short   d1;     /* number of elements in dimension 1 */
            unsigned short   d2;     /* number of elements in dimension 2 */
            unsigned short   d3;     /* number of elements in dimension 3 */
        } array;

    } val;

    short    flag;                 /* type of argument or return */

} VAL, *PVAL;

/* These must match the sytems XtInput...Mask in Intrinsic.h */
#define INPUT_MASK_READ      1
#define INPUT_MASK_WRITE     2
#define INPUT_MASK_EXCEPTION 4

#define INVALID_INPUTID      (-1)

typedef LONG INPUTID;
typedef VOID (*CALLBACKFUNC) PROTO((VOID*, INT*, INPUTID*));
typedef VOID (*TIMEDFUNC) PROTO((VOID*, VOID*));

/* conveniance functions */
#define xfSetErr(P, E)      do { (P)->flag = ERR; \
                            (P)->val.err = (E); } while (0)
#define xfSetLong(P, L)     do { (P)->flag = NUMERIC; \
                            (P)->val.numeric = (DOUBLE)(L); } while (0)
#define xfSetDouble(P, D)   do { (P)->flag = NUMERIC; \
                            (P)->val.numeric = (D); } while (0)
#define xfSetString(P, S)   do { (P)->flag = STRING; \
                            (P)->val.string = (S) ? (char*)(S) : ""; } while (0)

extern char           *p2ccopy();
extern unsigned char  *c2pcopy();
extern unsigned short ustrcat();
extern unsigned short ustrncat();
extern short          ustrcmp();
extern unsigned short ustrcpy();
extern unsigned short ustrncpy();
extern BOOL           xfNewArray();
extern BOOL           xfSetArrayEl();
extern BOOL           xfSetArrayNumEl();
extern BOOL           xfSetArrayStrEl();
extern BOOL           xfGetArrayEl();
extern BOOL           xfCheckArrayIndex();
extern void           xfFreeArray();

/* generic specials */
extern void           xfSetTimedFunc();
extern INPUTID        xfAddInput();
extern void           xfRemoveInput();
extern void           xfRemoveTimedFunc();

#endif /* !WZ_INTERNAL */

#ifdef __cplusplus
}
#endif

#endif /* #ifndef __IATTTOOLS_INCLUDED */
