#include <stdio.h>
#include <stdlib.h>
#include <string.h>
#include <dirent.h>
#include "globals.h"
#include <X11/xpm.h>

typedef Pixmap * RecognizePattern(char *,char *);
typedef void CallBack(char *);

struct Pattern{
          RecognizePattern *R_P;          
          CallBack *C_B;
          void * data;
              };

struct Pattern **patterns;
int patternsfree=-1,patternsize=-1;	
#define PS 15

void InitPatterns(void)
{
patterns=NULL;
(void *)patterns=calloc(PS,sizeof(struct Pattern *));
if(patterns==NULL){
  perror("file_types.InitPatterns()");
  exit(-1);
    }
patternsfree=0;
patternsize=PS;
}

void ExpandPatterns(void)
{
int i;
struct Pattern **p;

p=NULL;
(void *)p=calloc(patternsize+PS,sizeof(struct Pattern *));
if(p==NULL){
  perror("file_types.ExpandPatterns()");
  exit(-1);
    }

for(i=0;i<patternsfree;i++)p[i]=patterns[i];
free(patterns);
patterns=p;
patternsize+=PS;
}


void FreePatterns(void)
{
int i;

for(i=0;i<patternsfree;i++)free(patterns[i]);
free(patterns);
patternsize=-1;
patternsfree=-1;
}


int RegisterPattern(struct Pattern *p)
{
int k;
if(patternsfree+3>patternsize)ExpandPatterns();
k=patternsfree;
patterns[k]=p;
patternsfree++;
return k;
}

/*   some predefined filetypes */

#ifndef xpmEXT
#define xpmEXT ".xpm"
#endif

char XPMext[]=xpmEXT ;

int isXPM(char *filename)
{
int len,i,ans;
len=strlen(filename);

if(len <= strlen(XPMext)) return(0);
for(ans=1,i=1;i<=strlen(XPMext);i++)ans=ans &&
            (filename[len-i]==XPMext[strlen(XPMext)-i]);

return(ans);
}

Pixmap * RecognizeXPM(char *path,char *dpname)
{
Pixmap *data,*shape;
XpmAttributes *xpmattrib;
char *filename;

filename=strdup(strcat(strcat(path,"/"),dpname));
if(!isXPM(filename))return NULL;


data=calloc(1,sizeof(Pixmap));
shape=calloc(1,sizeof(Pixmap));
xpmattrib=calloc(1,sizeof(XpmAttributes));

if(XpmReadFileToPixmap(display,root,filename,data,shape,xpmattrib)<0)
    {
     #ifdef __DEBUG__
    fprintf(stderr,"Error reading file %s\n",filename);
     #endif
    free(data);
    free(shape);
    free(xpmattrib);
    return NULL;
    }
    else return data;
}    

void XPMCallBack(char *filename)
{
#ifdef __DEBUG__
fprintf(stdout,"%s\n",filename);
#endif
}

void RegisterXPMtype(void)
{
struct Pattern *p;

p=NULL;
(void *)p=calloc(1,sizeof(struct Pattern));
if(p==NULL){
  perror("file_types.RegisterXPMtype()");
  exit(-1);
  }
 p->R_P=& RecognizeXPM;
 p->C_B=& XPMCallBack;
 p->data=NULL;
 

RegisterPattern(p);
}
