/*
calctheta.c Version 2.3.0
Copyright (C) 2001-2010  dondalah721@yahoo.com (Dondalah)

This program is free software; you can redistribute it and/or
modify it under the terms of the GNU General Public License
as published by the Free Software Foundation; either version 2
of the License, or (at your option) any later version.

This program is distributed in the hope that it will be useful,
but WITHOUT ANY WARRANTY; without even the implied warranty of
MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
GNU General Public License for more details.

You should have received a copy of the GNU General Public License
along with this program; if not, write to:

	Free Software Foundation, Inc.
	59 Temple Place - Suite 330
	Boston, MA  02111-1307, USA.
*/

#include <math.h>

/* From Hugh Kenner */
/* Geodesic math and how to use it */
/* Berkeley: University of California Press, 1976 */
/* ISBN: 0-520-02924-0 */

/* Equations 12.4, 12.5, 12.6, and 12.8 */
/* This function calculates the value of theta */
/* based on the positions of x, y, and z in the */
/* symmetry triangle of an icosahedron. */
/* This function is used in a Class I calculation */
/* of a geodesic sphere */

/* Values of x,y,z in the icosacap triangle
   of a 2v geodesic sphere:

   First  digit is x.
   Second digit is y.
   Third  digit is z.

                            0,0,2
                             /\
                           /   \
                         /      \
                       /         \
               0,1,1  ------------  1,0,1
                    / \          / \
                  /    \       /    \
                /       \    /       \
              /          \ /          \
             --------------------------
          0,2,0         1,1,0        2,0,0

*/

double calctheta(x,y,z,freq)
double x,y,z,freq;
   {
   double theta,x1,y1,z1;
   double getx(),gety(),getz();
   double gettheta();
   /* Equation 12.4 */
   x1 = getx(x);
   /* Equation 12.5 */
   y1 = gety(x,y);
   /* Equation 12.6 */
   z1 = getz(z,freq);
   /* Equation 12.8 */
   theta = gettheta(x1,y1,z1);
   return(theta);
   } /* calctheta */
