/*
getz.c Version 2.3.0
Copyright (C) 2001-2010  dondalah721@yahoo.com (Dondalah)

This program is free software; you can redistribute it and/or
modify it under the terms of the GNU General Public License
as published by the Free Software Foundation; either version 2
of the License, or (at your option) any later version.

This program is distributed in the hope that it will be useful,
but WITHOUT ANY WARRANTY; without even the implied warranty of
MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
GNU General Public License for more details.

You should have received a copy of the GNU General Public License
along with this program; if not, write to:

	Free Software Foundation, Inc.
	59 Temple Place - Suite 330
	Boston, MA  02111-1307, USA.
*/

#include <math.h>

/* From Hugh Kenner */
/* Geodesic math and how to use it */
/* Berkeley: University of California Press, 1976 */
/* ISBN: 0-520-02924-0 */

/* Equation 12.6 */
/* This formula calculates the value of z1 */
/* based on: */

/*    the position of z in the symmetry triangle */
/*    the frequency of the geodesic sphere */

/* This formula is used in a Class I calculation */
/* of a geodesic sphere based on an icosahedron. */

/* Since the frequency of a geodesic sphere is never */
/* less than 1, the result of this subroutine is always */
/* positive.  The result of this subroutine is used */
/* as the denominator in the Class I calculation of */
/* theta.  See gettheta(x,y,z). */

/* Values of x,y,z in the icosacap triangle
   of a 2v geodesic sphere:

   First  digit is x.
   Second digit is y.
   Third  digit is z.

                            0,0,2
                             /\
                           /   \
                         /      \
                       /         \
               0,1,1  ------------  1,0,1
                    / \          / \
                  /    \       /    \
                /       \    /       \
              /          \ /          \
             --------------------------
          0,2,0         1,1,0        2,0,0

*/

/* Tau is the golden proportion: */
/*    (1 + sqrt(5)) / 2    */
/*    or 1.61803399        */
/*    or 2 * cos(36)       */

double getz(z,freq)
double z,freq;
   {
   double z1,tau,gettau();
   tau = gettau();
   /* z1 = (freq / 2.0) + (z / tau); */
   z1 = (freq * 0.5) + (z / tau);
   return(z1);
   } /* getz */
