/*
rottheta.c Version 2.3.0
Copyright (C) 2001-2010  dondalah721@yahoo.com (Dondalah)

This program is free software; you can redistribute it and/or
modify it under the terms of the GNU General Public License
as published by the Free Software Foundation; either version 2
of the License, or (at your option) any later version.

This program is distributed in the hope that it will be useful,
but WITHOUT ANY WARRANTY; without even the implied warranty of
MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
GNU General Public License for more details.

You should have received a copy of the GNU General Public License
along with this program; if not, write to:

	Free Software Foundation, Inc.
	59 Temple Place - Suite 330
	Boston, MA  02111-1307, USA.
*/

#include <math.h>

/* From Hugh Kenner */
/* Geodesic math and how to use it */
/* Berkeley: University of California Press, 1976 */
/* ISBN: 0-520-02924-0 */

/* equation 14.1 */
/* The rotation formula tells us that when phi,theta */
/* moves to 0,0, then theta1 moves to theta2. */

double rottheta(phi,theta,phi1,theta1)
double phi,theta,phi1,theta1;
   {
   double diff,theta2,term1,term2;
   diff = phi - phi1;
   term1 = cos(theta) * cos(theta1);
   term2 = sin(theta) * sin(theta1) * cos(diff);
   theta2 = acos(term1 + term2);
   return(theta2);
   } /* rottheta */
