#!/usr/bin/perl

# genmak.pl Version 2.3.0
# Copyright (C) 2001-2010  dondalah721@yahoo.com (Dondalah)

# This program is free software; you can redistribute it and/or
# modify it under the terms of the GNU General Public License
# as published by the Free Software Foundation; either version 2
# of the License, or (at your option) any later version.

# This program is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
# GNU General Public License for more details.

# You should have received a copy of the GNU General Public License
# along with this program; if not, write to:

# 	Free Software Foundation, Inc.
# 	59 Temple Place - Suite 330
# 	Boston, MA  02111-1307, USA.

# This script creates a make file for compiling
# a Class II Method 3 icosahedron geodesic sphere
# top symmetry triangle.


$FREQ = shift @ARGV;
if ($FREQ < 1)
   {
   print STDERR "Frequency too small.\n";
   die;
   }
elsif ($FREQ > 32)
   {
   print STDERR "Frequency is 2,4,6,...,32.";
   die;
   }
$TMP = $FREQ % 2;
die "Frequency $FREQ is not an even number"
   if ($TMP);
print "\#!/usr/bin/make\n";
print "\# Copyright (C) 2001-2010  dondalah\@ripco.com (Dondalah)\n";
print "\# Frequency = $FREQ\n";
print "\# This make file is protected by the GNU Public License.\n";
print "\# See http://www.gnu.org/copyleft/gpl.html.\n";
print "CC=gcc\n\n";
print "LDFLAGS=-lm -L. -lgeod\n\n";
print "c2m3v$FREQ:\t\tc2m3v$FREQ.c libgeod.a\n";
print "\t\$(CC) c2m3v$FREQ.c -o c2m3v$FREQ \$(LDFLAGS)\n";
print "\tc2m3v$FREQ | less\n\n";
print "clear:\n";
print "\trm c2m3v$FREQ\n";
