/*
getirad.c Version 2.3.0. Calculate the circumscribed radius
of an icosahedron based on side = 1.
Copyright (C) 2001-2010  dondalah721@yahoo.com (Dondalah)

This program is free software; you can redistribute it and/or
modify it under the terms of the GNU General Public License
as published by the Free Software Foundation; either version 2
of the License, or (at your option) any later version.

This program is distributed in the hope that it will be useful,
but WITHOUT ANY WARRANTY; without even the implied warranty of
MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
GNU General Public License for more details.

You should have received a copy of the GNU General Public License
along with this program; if not, write to:

	Free Software Foundation, Inc.
	59 Temple Place - Suite 330
	Boston, MA  02111-1307, USA.
*/

#include <math.h>

/* The length of the side = 1 and the radius */
/* of an icosahedron is defined by the irad */
/* formula below. */
/* The formula for the radius of an icosahedron */
/* comes from CRC Standard Mathematical Tables, */
/* The Chemical Rubber Company. */

double getirad()
   {
   double irad;
   /* Calculate the circumscribed radius of an */
   /* icosahedron whose side length = 1 */
   irad = sqrt(10.0 + 2.0 * sqrt(5.0)) * 0.25;
   return(irad);
   } /* getirad */
