/*****************************************************************************

 		BIM-XXX-RS232 Radio Transceiver driver.
	Copyright (c) 1997 Walter Fetter Lages <w.fetter@ieee.org>
    This program is free software; you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation; either version 2 of the License, or
    (at your option) any later version.

    This program is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with this program; if not, write to the Free Software
    Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.

    Please note that the GPL allows you to use the driver, NOT the radio.
    In order to use the radio, you need a license from the communications
    authority of your country.
	
*****************************************************************************/

#ifndef _BIM_H
#define _BIM_H

#include <linux/ioctl.h>

#define BIM_MAJOR 		51

// maximum packet length, excluding CRC
#define BIM_MAXFLEN 		400	

// the ioctl type of this driver
#define BIM_IOCTL_TYPE       'B'

#define KISS_FEND   ((unsigned char)0300)
#define KISS_FESC   ((unsigned char)0333)
#define KISS_TFEND  ((unsigned char)0334)
#define KISS_TFESC  ((unsigned char)0335)

#define KISS_CMD_DATA       0
#define KISS_CMD_TXDELAY    1
#define KISS_CMD_PPERSIST   2
#define KISS_CMD_SLOTTIME   3
#define KISS_CMD_TXTAIL     4
#define KISS_CMD_FULLDUP    5

// modem type
#define BIM_INVALID		0
#define BIM_MODEM		1
#define BIM_CABLE		2

// ioctl constants
#define BIMCTL_GETDCD           _IOR(BIM_IOCTL_TYPE,0,unsigned char)
#define BIMCTL_GETPTT           _IOR(BIM_IOCTL_TYPE,1,unsigned char)
#define BIMCTL_PARAM_TXDELAY    _IO(BIM_IOCTL_TYPE,2)
#define BIMCTL_PARAM_PPERSIST   _IO(BIM_IOCTL_TYPE,3)
#define BIMCTL_PARAM_SLOTTIME   _IO(BIM_IOCTL_TYPE,4)
#define BIMCTL_PARAM_TXTAIL     _IO(BIM_IOCTL_TYPE,5)
#define BIMCTL_PARAM_FULLDUP    _IO(BIM_IOCTL_TYPE,6)
#define BIMCTL_GETSTAT          _IOR(BIM_IOCTL_TYPE,7,struct bim_statistics)
#define BIMCTL_GETPARAMS        _IOR(BIM_IOCTL_TYPE,8,struct bim_params)
#define BIMCTL_SETPARAMS        _IOR(BIM_IOCTL_TYPE,9,struct bim_params)

#ifdef BIM_DEBUG
// these are mainly for debugging purposes
#define BIMCTL_GETBITS          _IOR(BIM_IOCTL_TYPE,17,unsigned char)
#define BIMCTL_DEBUG1           _IOR(BIM_IOCTL_TYPE,18,unsigned long)
#define BIMCTL_DEBUG2           _IOR(BIM_IOCTL_TYPE,19,unsigned long)
#endif //BIM_DEBUG

struct bim_statistics
{
	unsigned long rx_packets;
	unsigned long tx_packets;
	unsigned long ptt_keyed;
	unsigned long rx_bufferoverrun;
	unsigned long tx_bufferoverrun;
};

struct bim_params
{
	int iobase;
	int irq;
	int type;
	int baud;	
	int tx_delay;  // the transmitter keyup delay in 10ms units
	int tx_tail;   // the transmitter keyoff delay in 10ms units
	int slottime;  // the slottime in 10ms; usually 10 = 100ms
	int ppersist;  // the p-persistence 0..255
	int fulldup;   // the driver does not support full duplex, setting
	               // this just makes the driver send even if DCD is on
};	

#endif /* _BIM_H */

