#!/bin/sh
###############################################################################
###############################################################################
#                               install
###############################################################################
###############################################################################
# copyright (C) 2002-2003 Andres Garcia Garcia - fandom@retemail.es
# Distributed under the terms of the GPL v2
###############################################################################
###############################################################################
# Version 1.0
###############################################################################
###############################################################################
# This little script is only good for installing Getleft into you system
###############################################################################
# First of all we check whether we are going to use a console or graphic
# install
# \
if [ -n "$DISPLAY" ] ; then
# \
    if [ $# -eq 0 ] ; then
# \
        installSHELL="wish"
# \
    fi
# \
fi
# \
if [ -z $installSHELL ] ; then
# \
    installSHELL="tclsh"
# \
fi
# Now we have to check for a valid 'tclsh' or 'wish', we have to be so convoluted
# because FreeBSD, and I guess others, doesn't have a working shell in 'tclsh' or 
# 'wish', so you have to include the version number \
wish=`( for name in $(ls $(echo $PATH | sed 's/:/ /g') 2> /dev/null | grep ${installSHELL}8.4); do echo $name ; done ) | tail -1`
# \
[ -z "$wish" ] && wish=`(for name in $(ls $(echo $PATH | sed 's/:/ /g') 2> /dev/null | grep ${installSHELL}8.3); do echo $name ; done ) | tail -1`
# \
[ -z "$wish" ] && wish=`(for name in $(ls $(echo $PATH | sed 's/:/ /g') 2> /dev/null | grep ${installSHELL}8.2); do echo $name ; done ) | tail -1`
# \
[ -z "$wish" ] && wish=`(for name in $(ls $(echo $PATH | sed 's/:/ /g') 2> /dev/null | grep ${installSHELL}8.1); do echo $name ; done ) | tail -1`
# \
[ -z "$wish" ] && wish=${installSHELL}
# \
exec $wish "$0" ${1+"$@"}

catch {wm withdraw .}

################################################################################
# InstallDirs  
#    Sets the directories in which we are goin to install or uninstall the 
#    program.
################################################################################
proc InstallDirs {} {
    global installDirs options

    if {$options(prefix)=="/usr"} {
        set installDirs(etc) /etc
    } else {
        set installDirs(etc) /usr/local/etc
    }
    set installDirs(bin) [file join $options(prefix) bin]
    set installDirs(lib) [file join $options(prefix) lib getleft]
    set installDirs(img) [file join $options(prefix) share getleft images]
    set installDirs(lan) [file join $options(prefix) share getleft languages]
    set docRoot [file join $options(prefix) share doc]
    if {[file exists $docRoot]} {
        set installDirs(doc) [file join $options(prefix) share doc getleft-1.1]
    } else {
        set installDirs(doc) [file join $options(prefix) doc getleft-1.1]
    }
    return
}

################################################################################
# WriteConfFile
#    Finally we write the file with the configuration.
################################################################################
proc WriteConfFile {} {
    global options consoleInstall installDirs

    set confFile [file join $installDirs(etc) getleft.conf]

    if {[catch {open $confFile w} handle]} {
        if {$consoleInstall==1} {
            puts "Couldn't open file: $handle"
        } else {
            tk_messageBox -type ok -icon error -title Error \
                -message "Couldn't open file: $handle"
        }
        exit
    }
    puts $handle "# Configure file for Getleft\n"
    puts $handle "\[scripts\]\n"
    puts $handle "$installDirs(lib)\n"
    puts $handle "\[doc\]\n"
    puts $handle "$installDirs(doc)\n"
    puts $handle "\[languages\]\n"
    puts $handle "$installDirs(lan)\n"
    puts $handle "\[images\]\n"
    puts $handle "$installDirs(img)\n"
    puts $handle "\[icons\]\n"
    puts $handle "$installDirs(img)/Crystal\n"

    if {$options(proxy)!=""} {
        puts $handle "\[proxy\]\n"
        puts $handle "$options(proxy)\n"
        puts $handle "\[sameProxy\]\n"
        puts $handle "1\n"
    }
    puts $handle "\[language\]\n"
    puts $handle $options(lang)\n

    return
}

################################################################################
# InstallFiles
#    We get to do what we came here to do, get the files into your system.
################################################################################
proc InstallFiles {} {
    global options installDirs

    InstallDirs

    file copy -force Getleft.tcl $installDirs(bin)
    if {![file exists $installDirs(lib)]} {
        file mkdir $installDirs(lib)
    }
    foreach scriptFile [glob scripts/*] {
        file copy -force $scriptFile $installDirs(lib)
    }
    if {![file exists $installDirs(img)]} {
        file mkdir $installDirs(img)
    }
    foreach file [glob -nocomplain [file join $installDirs(img) *]] {
        file delete -force $file
    }
    foreach imgFile [glob images/*] {
        file copy -force $imgFile $installDirs(img)
    }
    if {![file exists $installDirs(lan)]} {
        file mkdir $installDirs(lan)
    }
    foreach lanFile [glob Languages/*] {
        file copy -force $lanFile $installDirs(lan)
    }
    if {![file exists $installDirs(doc)]} {
        file mkdir $installDirs(doc)
    }
    foreach docFile [glob doc/*] {
        file copy -force $docFile $installDirs(doc)
    }
    return
}

################################################################################
# ShowUsage
#    Shows a little message with the expected usage.
################################################################################
proc ShowUsage {} {

    puts "Usage: install.tcl --prefix=/path ?--lang=lanCode? ?--proxy=proxyIp:proxyPort?"

    exit
}

################################################################################
# ValidPath
#    Checks whether the given path is ok.
#
# Returns
#    '1': the path is ok.
#    '0': it isn't.
################################################################################
proc ValidPath {path} {
    global env

    if {[regexp {^(/usr)(/)?$} $path]} {
        return 1
    }
    if {[regexp {^(/usr/local)(/)?$} $path]} {
        return 1
    }
    return 0
}

################################################################################
# ValidLang
#    Checks whether the code represents a supported language.
#
# Returns
#    '1': the language is supported.
#    '0': it isn't
################################################################################
proc ValidLang {code} {

    if {($code=="en")||($code=="es")||($code=="fr")||($code=="pl")        \
            ||($code=="ko")||($code=="de")||($code=="nl")||($code=="it")  \
            ||($code=="pt")||($code=="eo")||($code=="ru")||($code=="zht") \
		||($code=="tr")} {
        return 1
    }
    return 0
}

################################################################################
# ValidProxy
#    Checks whether the given proxy looks right.
#
# Returns
#    '1': it looks ok.
#    '0': it doesn't
################################################################################
proc ValidProxy {proxy} {
    return [regexp {(.+)(:)([0-9]+)} $proxy]
}

################################################################################
# ProcessArgs
#    Parse the command line for options.
################################################################################
proc ProcessArgs {} {
    global argv options

    foreach parameter $argv {
        if {![regexp {(?:--)(.*)(?:=)(.*)} $parameter nada option value]} {
            puts "Bad parameter: $parameter"
            ShowUsage
        }
        if {[lsearch [list prefix proxy lang] $option]==-1} {
            puts "Bad option: $option"
            ShowUsage
        }
        set options($option) $value
    }
    if {![info exists options(prefix)]} {
       ShowUsage
    }
    set options(prefix) [string trimright $options(prefix) /]
    return
}

################################################################################
# ConsoleInstall
#    If we are running the script from the console.
################################################################################
proc ConsoleInstall {} {
    global argv argc options

    if {$argc==0} {
        ShowUsage
    }
    ProcessArgs
    if {(![info exists options(prefix)])||(![ValidPath $options(prefix)])} {
        ShowUsage
    }
    if {([info exists options(lang)])&&(![ValidLang  $options(lang)])} {
        puts "Unsupported language: $options(lang)"
        exit
    }
    if {($options(proxy)!="")&&(![ValidProxy $options(proxy)])} {
        puts "Proxy: $options(proxy) doesn't look right"
        exit
    }
    
    return
}

################################################################################
# checkCancel
#     When the user click on cancel or tries to close the window, we will first
#     check that he really means it.
################################################################################
proc CheckCancel {} {

    set what [tk_messageBox -type yesno -icon question -parent .wizard \
            -message "Are you sure?" -title Exit]

    if {$what!="no"} {
        exit
    }

    focus .wizard
    return
}

################################################################################
# DefineWizard
################################################################################
proc DefineWizard {} {
    global labelButtons logo

    source scripts/tkwizard.tcl
    source scripts/FrameLabel.tcl
    source scripts/Ccombinado.tcl
    source scripts/menuEntry.tcl

    set labelButtons(back)   "< Back"
    set labelButtons(next)   "Next >"
    set labelButtons(finish) "Finish"
    set labelButtons(cancel) "Cancel"
  
    set logo [image create photo \
            -file [file join doc logo.gif]]

    tkwizard::tkwizard .wizard -title {Getleft install}

    .wizard eval {
        variable wizData

        # default values
        catch {unset wizData}

        bind .wizard  <<WizCancel>> {
            CheckCancel
        }
    }

    .wizard step {installDir} -layout basic {
        variable wizData
        global logo env options

        set c [$this widget clientArea]

        set combo [Ccombinado::ComboBox $c.path [list /usr /usr/local] \
                -default "/usr/local" -fg black -bg white  -width 20   \
                -activeentry 0 -textvariable options(prefix)]

        pack $combo -padx 5 -pady 44
        bind .wizard  <<WizNextStep>> {
            if {![ValidPath $options(prefix)]} {
                tk_messageBox -title Error -type ok -icon error \
                        -message "Invalid path" -parent .wizard
                break
            }
        }

        $this stepconfigure                               \
            -title {Please, choose the install directory} \
            -icon $logo                                   \
            -subtitle {}                                  \
            -pretext {}                                   \
            -posttext {}
    }
            
    .wizard step {defaultLang} -layout basic {
        variable wizData
        global logo options

        set c [$this widget clientArea]

        set handle [open [file join Languages supported] r]
        set encoding cp1252
        fconfigure $handle -encoding $encoding
        for {set supportedLang(langList) ""} {![eof $handle]} {} {
            set line [gets $handle]
            if {[regexp {^#|^ |^$} $line]} continue
            set key      [lindex $line 0]
            set encoding [lindex $line 2]
            if {[catch {encoding convertfrom $encoding [lindex $line 1]} language]} {
                continue
            }
            set supportedLang($key)         $encoding
            set supportedLang($language)    $key
            lappend supportedLang(langList) $language
        }
        set supportedLang(langList) [lsort $supportedLang(langList)]

        foreach lang $supportedLang(langList) {
            set radio($lang) [radiobutton $c.radio$lang -text $lang   \
                    -value $supportedLang($lang)                      \
                    -variable options(lang)]
        }
        set options(lang) en
        set i 0
        set j 0
        foreach lang $supportedLang(langList) {
            grid $radio($lang) -padx 5 -row $i -column $j -sticky w
            incr j
            if {$j==3} {
                set j 0
                incr i
            }
        }
        $this stepconfigure                          \
            -title {Please, choose default language} \
            -subtitle {}                             \
            -icon $logo                              \
            -pretext {}                              \
            -posttext {}
    }
            
    .wizard step {confProxy} -layout basic {
        variable wizData
        global logo ip

        set c [$this widget clientArea]

        set marcoIn   [frame $c.marcoIn]
        set marcoIp   [fl::FrameLabel $marcoIn.marcoIp   -bd 2 -relief groove\
                -text "http proxy"]

        set label1 [label $marcoIp.label1 -text http:]
        set ip(1)  [entry $marcoIp.1 -width 20 -bg white -fg black -justify  left -textvariable ip(proxyIp)]
        set ip(2)  [entry $marcoIp.2 -width 4  -bg white -fg black -textvariable ip(proxyPort)]
        set colon1 [label $marcoIp.colon1 -text : -width 2]

        grid $marcoIn -pady 20
        grid $marcoIp -padx 10  -ipadx 20 -ipady 20 -sticky ns
        grid $label1 -in $marcoIp -row 0 -column 0 -sticky w -pady 3
        grid $ip(1)  -in $marcoIp -row 0 -column 1 -sticky w -pady 3
        grid $colon1 -in $marcoIp -row 0 -column 2 -sticky w -pady 3
        grid $ip(2)  -in $marcoIp -row 0 -column 3 -sticky e -pady 3

        focus $ip(1)
        bind $ip(1) <Return>   "focus $ip(2)"
        bind $ip(1) <KP_Enter> "focus $ip(2)"

        if {[info exists getleftOptions(httpProxy)]} {
            regexp {(.+)(?::)(.+)} $getleftOptions(httpProxy) nada name port
            $ip(1) insert insert $name
            $ip(2) insert insert $port
        }

        bind .wizard  <<WizFinish>> {
            if {($ip(proxyIp)!="")||($ip(proxyPort)!="")} {
                set options(proxy) $ip(proxyIp):$ip(proxyPort)
                if {![ValidProxy $options(proxy)]} {
                    tk_messageBox -title Error -type ok -icon error \
                            -message "Invalid proxy" -parent .wizard
                    break
                }
            }
            set ::wizardFinished 1
        }

        $this stepconfigure                       \
            -title {If needed, configure a proxy} \
            -icon $logo                           \
            -subtitle {}                          \
            -pretext {}                           \
            -posttext {}
    }

    return
}

################################################################################
# GraphicInstall
################################################################################
proc GraphicInstall {} {

    DefineWizard
    .wizard show
    tkwait variable wizardFinished

    return
}

if {$tcl_platform(platform)!="unix"} {
    tk_messageBox -title Error -type ok \
        -message "This install is only for Unix systems."
    exit
}

if {[regexp -nocase tclsh [info nameofexecutable]]} {
    set consoleInstall 1
} else {
    set consoleInstall 0
}

set options(proxy) ""
set options(lang)  en

if {(![file writable /usr])&&(![file writable /usr/local])} {
    if {$consoleInstall==1} {
        puts "You don't have the rights to install this in '/usr' or '/usr/local'"
    } else {
        tk_messageBox -type ok -title Error -icon error \
                -message "You don't have the rights to install this in '/usr' or '/usr/local'"
    }
    exit
}


if {$consoleInstall==1} {
    ConsoleInstall
} else {
    GraphicInstall
}

InstallFiles
WriteConfFile

if {$consoleInstall==1} {
    puts "Install finished"
} else {
    tk_messageBox -type ok -icon info -title Finished \
            -message "Install finished"
}

exit






