###############################################################################
###############################################################################
##                          Ayuda.tcl
###############################################################################
###############################################################################
## Includes the procedures needed for the commands in the 'help' menu
###############################################################################
###############################################################################
## (c) 1999-2003 Andrs Garca Garca. fandom@retemail.es
## You may distribute the contents of this file under the terms of the GPL v2
###############################################################################
###############################################################################

namespace eval Ayuda {

set tclLogo [image create photo -file "$dirGetleft(images)/pwrdLogo150.gif"]
set about   [image create photo -file "$dirGetleft(images)/about.gif"]
set curl    [image create photo -file "$dirGetleft(images)/curl.gif"]

if {$tcl_platform(platform)=="windows"} {
    package require registry
}

###############################################################################
# Manual
#   Shows Getleft's manual.
###############################################################################
proc Manual {} {
    global dirGetleft

    help::init [file join $dirGetleft(doc) help.help]  contents "" 450 525

    return
}

###############################################################################
# Changes
#   Shows the 'Changes' log
###############################################################################
proc Changes {} {
    global dirGetleft

    help::init [file join $dirGetleft(doc) help.help] changes

    return
}

###############################################################################
# Licence
#   Shows the GPL.
###############################################################################
proc Licence {} {
    global dirGetleft

    help::init [file join $dirGetleft(doc) help.help] GPL

    return
}

###############################################################################
# About
#    Shows some info about the program.
###############################################################################
proc About {} {
    global dirGetleft
    global labelButtons labelTitles indexButtons

    if {[winfo exists .acercade]} {
        raise .acercade .
        return
    }

    set coord(x) [winfo rootx .]
    set coord(y) [winfo rooty .]

    set ven [toplevel .acercade]
    wm title $ven $labelTitles(about)
    wm resizable $ven 0 0
    wm geometry  $ven +[expr {$coord(x)+180}]+[expr {$coord(y)+50}]

    set interno    [frame $ven.interno -bd 2 -relief sunken]
    set internoLft [frame $interno.left]
    set internoCnt [frame $interno.center]
    set internoRgt [frame $interno.right]

    set tclIma  [button $internoLft.tcl   -image $Ayuda::tclLogo -relief flat \
            -cursor hand2                                                     \
            -command "Ayuda::InvokeBrowser http://tcl.activestate.com $ven"]
    set textIma [button $internoCnt.texto -image $Ayuda::about   -relief flat \
            -cursor hand2                                                     \
            -command "Ayuda::InvokeBrowser http://personal1.iddeo.es/andresgarci/getleft/english/ $ven"]
    set curlIma [button $internoRgt.curl  -image $Ayuda::curl    -relief flat \
            -cursor hand2                                                     \
            -command "Ayuda::InvokeBrowser http://curl.haxx.se $ven"]
    set aceptar [underButton::UnderButton $ven.aceptar -buttontype button     \
            -textvariable labelButtons(ok) -command "destroy $ven"            \
            -under $indexButtons(ok)]

    pack $interno
    pack $internoLft $internoCnt $internoRgt -side left
    pack $tclIma
    pack $textIma
    pack $curlIma
    pack $ven.aceptar -pady 4

    bind $ven <Escape> "$aceptar invoke"

    focus $aceptar

    return
}

###############################################################################
# GuessLinuxBrowser
#    If the user hasn't set a browser yet we will try to guess it by using the
#    BROWSER enviromental variable, if that fails, Mozilla seems like a 
#    safe bet.
#
# Returns:
#    The browser to use.
###############################################################################
proc GuessLinuxBrowser {} {
    global env

    if {[info exists env(BROWSER)]} {
        return $env(BROWSER)
    }
    return mozilla
}

###############################################################################
# EnableBrowserEntry
#    Enables or disables the entry to choose a browser.
#
# Parameter:
#    entryPath: Just that.
###############################################################################
proc EnableBrowserEntry {entryPath} {
    variable browserTemp
    global   getleftOptions

    if {$browserTemp=="other"} {
        $entryPath configure -state normal                               \
                -bg $getleftOptions(bg)    -fg $getleftOptions(fg)
        focus $entryPath
    } else {
        $entryPath configure -state disabled                             \
                -bg $getleftOptions(disBg)    
    }
    return
}

###############################################################################
# ChooseLinuxBrowserCommon
#    This procedure takes care of creating the parts of the window that are
#    shared between the proper 'Choose Browser' dialog and the one in the 
#    configuration wizard.
#
# Parameter:
#    The widget in which it will be put.
###############################################################################
proc ChooseLinuxBrowserCommon {parent} {
    global getleftOptions getleftState labelDialogs labelFrames indexDialogs
    variable window

    set extFrame   [frame $parent.extFrame]
    set labelFrame [fl::FrameLabel $extFrame.labelFrame -bd 2 -relief groove   \
            -textvariable labelFrames(browser)]

    set galeon    [underButton::UnderButton $labelFrame.galeon                 \
            -value "galeon"   -buttontype radiobutton -under 0                 \
            -text Galeon    -variable Ayuda::browserTemp                       \
            -command "Ayuda::EnableBrowserEntry $labelFrame.browserEntry"]
    set konqueror [underButton::UnderButton [list $labelFrame.kfmclient openProfile webbrowsing] \
            -value [list kfmclient openProfile webbrowsing]                    \
            -buttontype radiobutton   -under 0     \
            -text Konqueror -variable Ayuda::browserTemp                       \
            -command "Ayuda::EnableBrowserEntry $labelFrame.browserEntry"]
    set mozilla   [underButton::UnderButton $labelFrame.mozilla                \
            -value "mozilla"  -buttontype radiobutton -under 0                 \
            -text Mozilla   -variable Ayuda::browserTemp                       \
            -command "Ayuda::EnableBrowserEntry $labelFrame.browserEntry"]
    set netscape  [underButton::UnderButton $labelFrame.netscape               \
            -value "netscape" -buttontype radiobutton -under 0                 \
            -text Netscape  -variable Ayuda::browserTemp                       \
            -command "Ayuda::EnableBrowserEntry $labelFrame.browserEntry"]
    set opera     [underButton::UnderButton $labelFrame.opera                  \
            -value "opera"    -buttontype radiobutton -under 4                 \
            -text Opera     -variable Ayuda::browserTemp                       \
            -command "Ayuda::EnableBrowserEntry $labelFrame.browserEntry"]
    set phoenix   [underButton::UnderButton $labelFrame.phoenix                \
            -value "phoenix"  -buttontype radiobutton -under 0                 \
            -text Phoenix   -variable Ayuda::browserTemp                       \
            -command "Ayuda::EnableBrowserEntry $labelFrame.browserEntry"]

    set other     [underButton::UnderButton $labelFrame.other                  \
            -value "other"    -buttontype radiobutton -under 1                 \
            -textvariable labelDialogs(other) -variable Ayuda::browserTemp     \
            -command "Ayuda::EnableBrowserEntry $labelFrame.browserEntry"]

    set browserEntry [entry $labelFrame.browserEntry -width 20                 \
            -bg $getleftOptions(bg) -fg $getleftOptions(fg)]

    set window(browserEntry) $browserEntry

    if {![info exists getleftState(browser)]} {
        set Ayuda::browserTemp other
        set getleftState(browser) [GuessLinuxBrowser]
    }

    if {[catch {$labelFrame.$getleftState(browser) invoke}]} {
        set browserTemp other
        $browserEntry delete 0 end
        $browserEntry insert 0 $getleftState(browser)
        focus $browserEntry
    } else {
        focus $labelFrame.$getleftState(browser)
    }

    grid $extFrame     -padx  10 -ipady 5
    grid $labelFrame   -ipadx 30 -ipady 7 -pady 5 -padx 3
    grid $galeon       -sticky w
    grid $konqueror    -sticky w
    grid $mozilla      -sticky w
    grid $netscape     -sticky w
    grid $opera        -sticky w
    grid $phoenix      -sticky w
    grid $other        -sticky w
    grid $browserEntry -sticky w

    return
}

###############################################################################
# ChooseLinuxBrowserControl
#    Gets invoked when the user accepts or cancels the dialog to choose the
#    Linux Broswer.
#
# Parameters:
#    set: '1' if the user accepted, so we set the browser.
#    parent: Window over which the messages will appear
#
# Returns:
#    '0' if all is well, '1' if it isn't.
###############################################################################
proc ChooseLinuxBrowserControl {set parent} {
    global   getleftState labelTitles labelMessages
    variable browserTemp
    variable window

    if {$set==1} {
        if {$browserTemp=="other"} {
            # No paths allowed.
            set temp [file tail [$window(browserEntry) get]]
            if {$temp==""} {
                tk_messageBox -type ok -icon error -parent $parent         \
                        -title $labelTitles(error)                         \
                        -message $labelMessages(fillBrowser)           
                return 1
            }
            set getleftState(browser) $temp
        } else {
            set getleftState(browser) $browserTemp
        }
    }

    catch {destroy .chooseBrowser}

    return 0
}

###############################################################################
# ChooseLinuxBrowser
#    Since I don't know how to get the favourite browser automagically, I 
#    will have to ask for it.
#
# Parameter
#    parent: Window over which the dialog will appear, it defaults to the
#            main window.
###############################################################################
proc ChooseLinuxBrowser {{parent .}} {
    global   getleftState labelButtons labelTitles labelMessages indexButtons
    global   tcl_platform
    variable window

    if {$tcl_platform(platform)!="unix"} {
        tk_messageBox -type ok -icon error -parent $parent                \
                -title $labelTitles(error) -message $labelMessages(noWin)
        return
    }

    if {[winfo exists .chooseBrowser]} { 
        raise $window(toplevel)
        return
    }

    set coord(x) [winfo rootx $parent]
    set coord(y) [winfo rooty $parent]

    set win [toplevel .chooseBrowser]
    wm title $win $labelTitles(chooseBrow)
    wm resizable $win 0 0
    wm geometry  $win +[expr {$coord(x)+125}]+[expr {$coord(y)+75}]

    set window(toplevel) $win

    ChooseLinuxBrowserCommon $win

    set buttons [frame  $win.extFrame.buttons]
    set accept  [underButton::UnderButton $buttons.accept -buttontype button  \
            -under $indexButtons(ok)     -textvariable labelButtons(ok)       \
            -width 8 -command "Ayuda::ChooseLinuxBrowserControl 1 $win"]
    set cancel  [underButton::UnderButton $buttons.cancel -buttontype button  \
            -under $indexButtons(cancel) -textvariable labelButtons(cancel)   \
            -width 8 -command "Ayuda::ChooseLinuxBrowserControl 0 $win"]

    bind $window(browserEntry) <Return>   "focus $accept"
    bind $window(browserEntry) <KP_Enter> "focus $accept"

    grid $buttons -sticky e
    grid $accept $cancel -padx 3

    return
}

###############################################################################
# ChangeHelpCursor
#    For a few seconds after clicking on a http link, the cursor will change
#    to the watch cursor.
#
# Parameter
#    Parent: The window for which the cursor will be changed.
###############################################################################
proc ChangeHelpCursor {parent} {
    
    $parent configure -cursor watch
    after 5000 "catch {$parent configure -cursor arrow}"

    return
}
###############################################################################
# InvokeBrowserWindows
#    Invokes the default internet browser in a Windows machine and opens the
#    page passed as a parameter.
#
#    I got most of this from a Chris Nelson entry at the Tclers' wiki.
#
# Parameter:
#    urlToOpen: The url to open after the browser start up.
#    parent: The window over which, if needed, the error message will appear,
#            default to the help window.
###############################################################################
proc InvokeBrowserWindows {urlToOpen parent} {
    global labelTitles labelMessages

    # Look for the application under HKEY_CLASSES_ROOT
    set root HKEY_CLASSES_ROOT

    # Get the application key for HTML files
    set appKey [registry get $root\\.html ""]

    # Get the command for opening HTML files
    set appCmd [registry get  $root\\$appKey\\shell\\open\\command ""]

    # Substitute the HTML filename into the command for %1,
    # IE doesn't seem to use the %1, so we simply append it.
    if {![regsub {%1} $appCmd "$urlToOpen" appCmd]} {
        set appCmd [concat $appCmd $urlToOpen]
    }

    # Double up the backslashes for eval.
    regsub -all {\\} $appCmd  {\\\\} appCmd

    # Invoke the command
    ChangeHelpCursor $parent
    if {[catch {eval exec $appCmd &}]} {
        tk_messageBox -type ok -icon error -title $labelTitles(error)    \
                -parent $parent -message $labelMessages(cantBrowser).
    }        
    return
}

###############################################################################
# InvokeBrowserLinux
#    Invokes the internet browser given by the user and opens the
#    page passed as a parameter.
#
# Parameter:
#    urlToOpen: The url to open after the browser start up.
#    parent: The window over which, if needed, the error message will appear.
###############################################################################
proc InvokeBrowserLinux {urlToOpen parent} {
    global getleftState labelTitles labelMessages

    ChangeHelpCursor $parent

    if {![info exists getleftState(browser)]} {
        set getleftState(browser) [GuessLinuxBrowser]
    }

    # I have to be this convoluted because to open Konqueror we have to
    # use a command with parameters and urls might have spaces.
    # It means though, that a command with a path that contains spaces
    # won't work, so no paths.
    if {[catch {eval "exec $getleftState(browser) [list $urlToOpen] &"}]} {
        tk_messageBox -type ok -icon error -title $labelTitles(error)    \
                -parent $parent                                          \
                -message "$labelMessages(cantBrowser):\n$getleftState(browser)"                                          \
    }
    return
}

###############################################################################
# InvokeBrowser
#    Invokes the default internet browser depending on the operating system
#    we are in.
#
# Parameters:
#    urlToOpen: The url to open after the browser starts up.
#    parent:    The window over which, if needed, the error messages will
#               appear, defaults to the help window.
###############################################################################
proc InvokeBrowser {urlToOpen {parent .tophelpwindow}} {
    global tcl_platform labelMessages

    if {(![regexp {:/} $urlToOpen])&&(![regexp {^/} $urlToOpen])} {
        set urlToOpen http://$urlToOpen
    }

    switch -exact -- $tcl_platform(platform) {
        windows {
            InvokeBrowserWindows $urlToOpen $parent
        }
        unix {
            InvokeBrowserLinux   $urlToOpen $parent
        }
        default {
            tk_messageBox -type ok -icon error -title $labelTitles(error)    \
                    -parent $parent                                          \
                    -message $labelMessages(noBrowser)
        }
    }
    return
}

}
