###############################################################################
###############################################################################
##                          EnterUrl
###############################################################################
###############################################################################
## Takes care of the dialog that prompts the user for an Url to download.
###############################################################################
###############################################################################
## (c) 2002-2003 Andrs Garca Garca. fandom@retemail.es
## You may distribute the contents of this file under the terms of the GPL v2
###############################################################################
###############################################################################

namespace eval EnterUrl {

###############################################################################
# EnterUrlChangeDir {currentDir}
#    Invoked when the user want to change the directory in which the site
#    will be saved.
#
# Side effect:
#    If the user actually changes the directory, the new one will be shown
#    in the 'Enter Url' dialog
###############################################################################
proc EnterUrlChangeDir {} {
    global dirGetleft env

    if {$dirGetleft(chDir)!=$env(HOME)} {
        set currentDir [file dirname $dirGetleft(chDir)]
    } else {
        set currentDir $env(HOME)
    }

    set dirGetleft(baseDir) [Dialogos::SelectDirectory                     \
            $currentDir .enterUrlWindow]

    if {$dirGetleft(baseDir)!=""} {
        set dirGetleft(chDir)   [file nativename $dirGetleft(baseDir)]
    }

    return
}

###############################################################################
# EnterUrlWindow
#    Creates a dialog box where you can write or paste the desired url.
#
# Parameter:
#    parent: The path of the toplevel window over which it will appear.
#    url:    The url that will appear in the dialog, if none is given it will
#            look in the selection.
#
# Returns:
#    The path of the entry in the combobox.
################################################################################
proc EnterUrlWindow {parent url} {
    global labelButtons labelTitles labelFrames labelDialogs labelMenus
    global urlHistory getleftState getleftOptions dirGetleft
    global indexButtons indexDialogs
    variable window

    set coord(x) [winfo rootx $parent]
    set coord(y) [winfo rooty $parent]

    set win [toplevel .enterUrlWindow]
    wm title $win $labelTitles(enterUrl)
    wm resizable $win 0 0
    wm geometry  $win +[expr {$coord(x)+100}]+[expr {$coord(y)+15}]

    set marcoEx [frame $win.marcoEx]
    set marcoUrl [fl::FrameLabel $marcoEx.marco -bd 2 -relief groove                      \
            -textvariable labelFrames(webPage)]
    set marcoUrlIn [frame $marcoUrl.marcoIn]
    if {$url==""} {
        set url [menuEntry::ReadSel]
    }
    set window(url) $url
    set urlCombo [Ccombinado::ComboBox $marcoUrlIn.url $urlHistory                        \
            -erasable 1  -default $url -fg $getleftOptions(fg)                            \
            -bg $getleftOptions(bg) -textvariable EnterUrl::window(url)]
    set startCheck [underButton::UnderButton $marcoUrlIn.start -buttontype checkbutton    \
            -variable getleftState(startNow)                                              \
            -textvariable labelDialogs(startNow) -under $indexDialogs(startNow)]

    set dirFrame    [fl::FrameLabel $marcoEx.dirFrame -bd 2 -relief groove                \
            -textvariable labelFrames(dir)]
    set dirIntFrame [frame $dirFrame.intFrame]
    set dirEntry [menuEntry::menuEntry $dirIntFrame.entry -width 40                       \
            -bg $getleftOptions(bg) -fg $getleftOptions(fg)                               \
            -textvariable dirGetleft(chDir)]

    set dirButton [underButton::UnderButton $dirIntFrame.button -buttontype button        \
            -width 10 -command "EnterUrl::EnterUrlChangeDir"                              \
            -textvariable labelButtons(select) -under $indexButtons(select)               \
            ]
    set dirGetleft(chDir)   [file nativename $dirGetleft(lastDir)]

    $dirEntry xview moveto 1.0

    set buttons [frame $win.buttons]
    set start   [underButton::UnderButton $buttons.start   -textvariable labelButtons(start)  \
            -width 8 -command "EnterUrl::EnterUrlControl 1" -under $indexButtons(start)       \
            -buttontype button ]
    set cancel  [underButton::UnderButton $buttons.cancel  -textvariable labelButtons(cancel) \
            -width 8 -command "EnterUrl::EnterUrlControl 0" -under $indexButtons(cancel)      \
            -buttontype button ]
    set options [underButton::UnderButton $buttons.options -textvariable labelButtons(options)\
            -width 8 -command "Opciones::ChooseOptions ::downOptionsTemp $win"                \
            -buttontype button  -under $indexButtons(options)]


    set window(win)      $win
    set window(combo)    $urlCombo
    set window(dirEntry) $dirEntry

    bind $urlCombo.entry <Return>   "focus $dirEntry"
    bind $urlCombo.entry <KP_Enter> "focus $dirEntry"

    bind $dirEntry       <Return>   "focus $start"
    bind $dirEntry       <KP_Enter> "focus $start"

    bind $win            <Escape>   "$cancel invoke"

    pack $marcoEx     -padx 10

    pack $marcoUrl    -ipady 10 -pady 10 -fill x
    pack $marcoUrlIn  -side bottom -padx 20
    pack $urlCombo   
    pack $startCheck  -pady 5 -side left

    pack $dirFrame    -ipady 10    -fill both
    pack $dirIntFrame -side left   -fill x    -padx 20
    pack $dirEntry    -side left   -pady 5
    pack $dirButton   -side left   -padx 5 

    pack $buttons     -side bottom -padx 7 -fill x
    pack $cancel $start $options -side right -padx 3 -pady 5

    focus $urlCombo.entry

    return $urlCombo.entry
}

###############################################################################
# EnterUrlControl
#    Checks the url entered and complains if it is not valid.
#    In practice, in considers just about anything to be valid.
#
# Parameter
#    done: '1' if the user clicked on start, '0' if he cancelled.
################################################################################
proc EnterUrlControl {done} {
    global labelTitles labelMessages
    global dirGetleft  directories getleftState
    variable window

    if {($done==0)||($window(url)=="")} {
        wm withdraw $window(win)
        return
    }

    set requestedUrl [string trim $window(url)]
    set parsedUrl    [HtmlParser::ParseUrl $requestedUrl]

    if {$parsedUrl==1} {
        tk_messageBox -title $labelTitles(error) -icon error -type ok         \
                -message "$labelMessages(noWWW)\n$requestedUrl"               \
                -parent $window(win)
        return
    }

    set dir $dirGetleft(chDir)
    if {$dir==""} {
        tk_messageBox -type ok -icon error -title $labelTitles(error)         \
                -message "Please, enter a directory" -parent $window(win)
        return
    }
    regsub -all {\\} $dir {/} dirGetleft(baseDir)
    if {![file exists $dirGetleft(baseDir)]} {
       set what [tk_messageBox -icon question                                 \
            -message $labelMessages(unknown) -title $labelTitles(unknown)     \
            -parent $window(win) -type yesno]
       switch $what {
            yes {
                file mkdir $dirGetleft(baseDir)
            }
            no return
	  }
    } else {
       if {![file isdirectory $dirGetleft(baseDir)]} {
           tk_messageBox -type ok -icon error -title $labelTitles(error)     \
                    -message "Please, enter a directory" -parent $window(win)
           return
       }
    }
    wm withdraw $window(win)

    regsub -all {\n}   $requestedUrl {}  requestedUrl
    regsub -all {\\}   $requestedUrl {/} requestedUrl
    regsub -all {\x00} $requestedUrl {}  requestedUrl

    set domain [string tolower [lindex [HtmlParser::ParseUrl $requestedUrl] 1]]

    PutUrlInHistory $requestedUrl

    PutUrlInQueue $requestedUrl $dirGetleft(baseDir) [array get ::downOptionsTemp]

    set dirGetleft(lastDir) $dirGetleft(baseDir)

    if {($getleftState(downloading)==0)&&($getleftState(startNow)==1)} {
        StartDownload $requestedUrl
    }

    return
}

###############################################################################
# EnterUrl
#    Creates a dialog box where you can write or paste the desired url.
#
# Returns:
#    The url entered by the user.
###############################################################################
proc EnterUrl {{map 0} {parent .} {url ""}} {
    global getleftOptions downOptions downOptionsTemp
    variable window

    if {[winfo exists .enterUrlWindow]} {
        raise $window(win) .
        if {[wm state $window(win)]!="withdrawn"} {
            return
        }
    }

    catch "unset ::downOptionsTemp"
    array set downOptionsTemp [array get downOptions]
    set downOptionsTemp(map) $map

    if {![winfo exists .enterUrlWindow]} {
        EnterUrlWindow $parent $url
    } else {
        if {$url!=""} {
            set window(url) $url
        } else {
            set window(url) [menuEntry::ReadSel]
        }
        set Ccombinado::cbArgs(items) $::urlHistory
        wm state $window(win) normal
    }
    return
}

}
