##############################################################################
##############################################################################
#                               Rizo.tcl
##############################################################################
##############################################################################
# In this file are implemented the procedures to actually do the downloading
# by executing 'cURL'.
##############################################################################
##############################################################################
# Copyright 1999-2003 Andrs Garca Garca  -- fandom@retemail.es
# Distributed under the terms of the GPL v2
##############################################################################
##############################################################################
namespace eval Rizo {

##############################################################################
# SetCurlVersion
# Getleft now only works with version 7.9 or newer.
##############################################################################
proc SetCurlVersion {} {
    global tcl_platform errorCode
    variable leftIndex
    variable speedIndex
    variable cookieJar

    if {[catch {exec curl -V} curlVersion]} {
        if {[lindex $errorCode 1]=="ENOENT"} {
            tk_messageBox -type ok -icon error -title "No curl" \
                -message "Getleft depends on program\n\tcURL\nPlease check the docs"
            exit
        }
    }

    if {![regexp {([0-9]+)(?:\.)([0-9]+)} $curlVersion nada mayor minor]} {
        tk_messageBox -type ok -icon error -title Error                      \
                -message "Program cURL doesn't work.\nPlease check the docs."
        exit
    }

    if {($mayor<7)||($minor<9)} {
        tk_messageBox -title Error -type ok \
                -message "Your 'cURL' version is too old,\n\
                          please upgrade"
        exit
    }
    set cookieJar [file join $::dirGetleft(conf) cookies.txt]

    # I define these indexes here because they have been known to change
    # with cURL versions.

    set leftIndex  10
    set speedIndex 11

    return
}

##############################################################################
# Common
#    This procedure takes care of initializing the state variables and invoke
#    'curl' for all the connection types.
#
# Parameters:
#    type: type of connection:
#           - cab: Headers
#           - dat: The link itself
#    args: args that will be passed to curl
##############################################################################
proc Common {type args} {
    global getleftOptions errorCode tcl_platform
    variable curlReport
    variable meta
    variable curlError
    variable errorMessage
    variable cookieJar
    variable pipe

    set curlReport(pause)          0
    set curlReport(speed)          0
    set curlReport(stop)           0
    set curlError                  0
    set errorMessage              ""
    set getleftOptions(cancelDown) 0
    set ::errorCode               ""

    set newArgs [concat {-A "Mozilla/4.0 (compatible; Getleft 1.1b2)"}        \
                         -b \"$cookieJar\" --connect-timeout 60 [lindex $args 0]]

    if {$getleftOptions(proxy)==1} {
        if {[regexp -nocase {(http://)} $newArgs]} {
            set proxy $getleftOptions(httpProxy)
        } else {
            set proxy $getleftOptions(ftpProxy)
        }
        if {$getleftOptions(useAuthProxy)} {
            set newArgs [concat \
                    -U $getleftOptions(proxyUser):$getleftOptions(proxyPass) \
                    $newArgs]
        }
        set curlCmd [concat curl -x $proxy $newArgs]
    } else {
        set curlCmd [concat curl $newArgs]
    }
#    if {$::DEBUG==1} {
#        puts $curlCmd
#    }

    if {$tcl_platform(platform)=="windows"} {
        set curlCmd [concat $curlCmd --stderr -]
        eval {set pipe [open "| $curlCmd" r]}
    } else {
        eval {set pipe [open "| $curlCmd 2>@ stdout" r]}
    }

    fileevent  $pipe readable [list ::Ventana::Rizo::Lector $type]
    fconfigure $pipe -blocking 0

    return
}

###############################################################################
# HeadRequest
#    Asks the server for the Headers of the link
#
# Parameters:
#    link: url to download
#    mother: referer page of the link
###############################################################################
proc HeadRequest {link mother} {
    variable meta

    set meta(content)       ""
    set meta(relocate)      ""
    set meta(charSet)       ""
    set meta(versionServer) ""
    set meta(totalBytes)    -1

    regsub -all { } $link {%20} link
    regexp {(.*)(#)} $link nada link

    if {$mother!="-"} {
        set args [list -e $mother -I $link]
    } else {
        set args [list -I $link]
    }
    Common cab $args

    return
}

###############################################################################
# DataRequest
#    Resumes, server allowing, a download
#
# Parameters:
#    file: full path of the file where the url will be downloaded
#    link: url to download
#    mother: referer page of the url
#    resume: '1' if we have to resume dodwnloading the file, defaults to '0'
###############################################################################
proc DataRequest {file link mother {resume 0}} {
    variable curlReport
    variable meta

    set curlReport(percentage) 0

    regsub -all { } $link {%20} link
    regexp {(.*)(#)} $link nada link
    if {$mother!="-"} {
        set refererUrl $mother
        set args [list -e $refererUrl -o $file $link]
    } else {
        set args [list -o $file $link]
    }

    if {$resume==1} {
        set args [concat $args -C -]
    }
    if {$meta(versionServer)>=1.1} {
        set args [concat $args --speed-time 300 --speed-limit 30]
    }
    Common dat $args

    return
}

###############################################################################
# Lector
#   This procedure controls the downloading, it is invoked anytime there is
#   something to proccess
#
# Parameters:
#   tipo: type of request (HEAD, GET, ...) or 'stopNow' to stop
###############################################################################
proc Lector {tipo} {
    global errorCode getleftState labelDialogs siteUrl tcl_platform
    variable meta
    variable curlReport
    variable curlError
    variable speedIndex
    variable leftIndex
    variable curlVersion
    variable errorMessage
    variable setCookie
    variable pipe

    if {($tipo=="stopNow")||($getleftState(downloading)==0)} {
        set pipePid [pid $pipe]
        if {$tcl_platform(platform)=="unix"} {
            catch {exec kill -9 $pipePid} result
        } else {
            winkill::kill $pipePid
        }
        catch {close $pipe}
        return
    }
    set endOfFile [eof $pipe]
    if {($endOfFile) || ($curlReport(stop)==1) || ($curlReport(pause)==1)} {
        if {($endOfFile)} {
            set curlReport(end) 1
        }
        fconfigure $pipe -blocking 1
        if {[catch {close $pipe}]} {
            set curlError [lindex $errorCode 2]
            if {$::DEBUG==1} {
                if {$curlError!=""} {
                    puts "Cdigo de error: $curlError - $errorCode"
                } else {
                    tk_messageBox -type ok -icon info -message "errorCurl empty - $errorCode"
                }
            }
	      if {(($curlError==18)&&($tipo=="cab"))||($curlError=="")} {
                set curlError 0
            }
            if {($curlError==7)||($curlError==6)} {
                if {![info exists getleftState(noConnect,$siteUrl(www))]} {
                    set getleftState(noConnect,$siteUrl(www)) 0
                } else {
                    incr getleftState(noConnect,$siteUrl(www))
                }
            }
        }
        return
    }
    if {[gets $pipe line]>=0} {
        if {[string match $line ""]} return
        if {$::DEBUG==1} {
           if {$tipo=="cab"} {
	            if {![regexp {^\s|^1} $line]} {
                   puts $line
		        }
            }
        }
        if {$tipo=="cab"} {
            if {[regexp -nocase {^(?:HTTP/)([0-9].[0-9])(?: )([0-9]*)(?: )(.*)} \
                    $line nada meta(versionServer) meta(code) meta(error)]} {
                if {$meta(code)>=400} {
                    set errorMessage $meta(error)
                    catch {error "Server Error" SERVER \
                            "Server \"$meta(error)\" $meta(code)"}
                    return
                }
            }
            regexp -nocase {^(Server: )(.*)}            $line meta(server)	        
            regexp -nocase {^(?:Location: )(.*)}        $line nada meta(relocate)
            regexp -nocase {^(?:Content-Type: )([^;]*)} $line nada meta(content)
            regexp -nocase {^(?:Last-Modified: )(.*)}   $line nada meta(lastModified)
            regexp -nocase {^(?:Content-Length: )(.*)}  $line nada meta(totalBytes)
            regexp -nocase {(?:charset=)(.*)} $line nada meta(charSet)
            if {[regexp -nocase {Set-Cookie} $line]} {
                Cookies::SaveCookie $line
            }
        } else {
#regsub -all {\s+} $line { } line
#puts "Antes:   $line"
	        if {[regexp {[^0-9kM:\.\s]} $line]!=0} return
#puts "Despues: $line"
            set curlReport(speed)  [lindex $line $speedIndex]

            if {$curlReport(speed)==""} return
            set curlReport(percentage) [lindex $line 0]
            if {[regexp {k$} $curlReport(speed)]} {
                set curlReport(speed) $curlReport(speed)/s
            } else {
                if {![regexp {/} $curlReport(speed)]} {
                    if {($curlReport(speed)>512)} {
                        catch {set curlReport(speed) \
                            "[format "%.2f" [expr {$curlReport(speed)/1024.0}]] k/s"}
                        regsub {\.} $curlReport(speed) $labelDialogs(decimal)\
                                curlReport(speed)
                    } else {
                        catch {set curlReport(speed) \
                            "[format "%.0f" $curlReport(speed)] bytes/s"}
                    }
                }
            }
            set curlReport(left) "[lindex $line $leftIndex] \
                    ( $curlReport(speed) )"
        }
    }
    return
}

}
