###############################################################################
###############################################################################
##                          UnderButton
###############################################################################
###############################################################################
## Manages creating buttons, plain, radio or check, with underscored letters.
###############################################################################
###############################################################################
## (c) 2003 Andrs Garca Garca. fandom@retemail.es
## You may distribute the contents of this file under the terms of the LGPL v2
###############################################################################
###############################################################################

namespace eval underButton {

###############################################################################
# Create
#    Creates the button and bind the key to it.
#
# Parameters
#    path: path to of the button to create.
#    args: Arguments to be passed to the button, the same as usual with one
#          addition: buttontype, either 'button', 'radiobutton' or
#          'checkbutton'.
###############################################################################
proc UnderButton {path args} {

    set buttonArgs ""
    foreach {option value} $args {
        switch -exact -- $option {
            -buttontype {
                set buttonType $value
            }
            default {
                lappend buttonArgs $option $value
                switch -exact -- $option {
                    -text {
                        set text $value
                    }
                    -textvariable {
                        set tmp $value
                        regsub {\(.*\)} $tmp {} tmp
                        global $tmp
                        set text [subst $$value]
                    }
                    -under {
                        set index [subst $value]
                    }
                }
            }
        }
    }
    eval $buttonType [list $path] $buttonArgs

    set parentWin [winfo toplevel $path]
    if {$index!=-1} {
        bind $parentWin <Alt-[string tolower [string index $text $index]]> "
            [list $path] invoke
            break
        "
    }
    
    return $path
}

}
