###############################################################################
###############################################################################
##                              getWizard.tcl
###############################################################################
###############################################################################
## Includes procedures to implement the configuration wizard, it was created 
## using tkwizard and tkwizthing by Bryan Oakley oakley_at_bardo.clearlight.com
###############################################################################
###############################################################################
## (c) 2001-2003 Andrs Garca Garca. fandom@retemail.es
## Distributed under the terms of the GPL v2
###############################################################################
###############################################################################

source [file join $dirGetleft(scripts) tkwizard.tcl]

tkwizard::tkwizard .wizard -title {Configure Getleft}

.wizard eval {
    variable wizData
    variable logo

    # default values
    if {[info exists wizData]} {
        unset wizData
    }

    set logo [image create photo \
            -file [file join "$dirGetleft(doc)" logo.gif]]

    bind .wizard <<WizCancel>> "
        tkwizard::.wizard::checkCancel
        break
    "
}

.wizard step {Language} -layout basic {
    global   getleftOptions supportedLang
    variable wizData

    set c [$this widget clientArea]

    foreach lang $supportedLang(langList) {
        set radio($lang) [radiobutton $c.radio$lang -text $lang   \
                -value $supportedLang($lang)                      \
                -variable getleftOptions(lang)                    \
                -command "tkwizard::.wizard::changeLanguage $supportedLang($lang)"]
    }

    if {![info exists getleftOptions(lang)]} {
        set getleftOptions(lang) en
    }
    changeLanguage $getleftOptions(lang)

    set i 0
    set j 0
    foreach lang $supportedLang(langList) {
        grid $radio($lang) -padx 5 -row $i -column $j -sticky w
        incr j
        if {$j==3} {
            set j 0
            incr i
        }
    }
    return
}
            
.wizard step {Proxy} -layout basic {
    variable wizData
    global   confWizardLabels

    set c [$this widget clientArea]
    $this stepconfigure                                     \
        -title    $confWizardLabels(proxTitle)              \
        -subtitle $confWizardLabels(proxSub)                \
        -pretext  {}                                        \
        -posttext {}

    Herramientas::ConfProxyWindowCommon $c


    set useEvent <<WizFinish>>
    if {$::tcl_platform(platform)=="unix"} {
        set useEvent <<WizNextStep>>
    }
    bind .wizard $useEvent "
        [namespace current]::proxyControl %W $useEvent
        break
    " 

    return
}

if {$::tcl_platform(platform)=="unix"} {
    .wizard step {Browser} -layout basic {
        variable wizData
        global   confWizardLabels

        set c [$this widget clientArea]
        $this stepconfigure                                 \
            -title    $confWizardLabels(browTitle)          \
            -subtitle $confWizardLabels(browSub)            \
            -pretext  {}                                    \
            -posttext {}

        Ayuda::ChooseLinuxBrowserCommon $c

        bind .wizard <<WizFinish>> "
            [namespace current]::browserControl %W
            break
        "
        return
    }
}

################################################################################
# proxyControl
#     Invokes the procedure that checks that the data entered for the proxy
#     is consistent.
#
# Parameter
#     W: The wizard window as returned by the event.
#     event: Whether we finish with this or not
################################################################################
proc tkwizard::.wizard::proxyControl {W useEvent} {

    set exitCode [::Herramientas::ConfProxyControl accept $W]
    if {$exitCode==0} {
        tkwizard::handleEvent $W $useEvent
        if {$useEvent=="<<WizFinish>>"} {
            destroy .wizard
        }
    }

    return
}

################################################################################
# browserControl
#     Checks whether all is well with the chose browser.
#
# Parameter
#     W: The wizard window as returned by the event.
#     event: Whether we finish with this or not
################################################################################
proc tkwizard::.wizard::browserControl {W} {

    set exitCode [::Ayuda::ChooseLinuxBrowserControl 1 $W]
    if {$exitCode==0} {
        destroy .wizard
    }

    return
}

################################################################################
# changeLanguage
#     When the user click on one of the language options, this procedure takes
#     care of actually changing the texts.
#
# Parameter
#     lan: code of the language, 'es', 'en', ...
################################################################################
proc tkwizard::.wizard::changeLanguage {lan} {
    global confWizardLabels getleftOptions
    variable logo

    ReadLangFile $lan

    wm title .wizard $confWizardLabels(title)

    .wizard stepconfigure                                   \
        -title    $confWizardLabels(lanTitle)               \
        -subtitle $confWizardLabels(lanSub)                 \
        -icon     $logo                                     \
        -pretext  {}                                        \
        -posttext {}

    return
}

################################################################################
# checkCancel
#     When the user click on cancel or tries to close the window, we will first
#     check that he really means it.
################################################################################
proc tkwizard::.wizard::checkCancel {} {
    global confWizardLabels

    set what [tk_messageBox -type yesno -icon question -parent .wizard \
            -message $confWizardLabels(sureMssg)                       \
            -title $confWizardLabels(sureTitle)]

    if {$what!="no"} {
        exit
    }

    focus .wizard
    return
}


.wizard show
tkwait window .wizard 
            
