/*
 * WEBGET
 * 
 * Copyright (C) 1998 Sven Oliver ("SvOlli") Moll
 * (smol0075@rz.uni-hildesheim.de, svolli@bigfoot.com)
 * 
 * This file uses code of GNU Finger.
 * 
 * Copyright (C) 1988, 1990, 1992 Free Software Foundation, Inc.
 * 
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2, or (at your option)
 * any later version.
 * 
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 */

#define CHECKPOINT fprintf(stderr,"%s:%d\n",__FILE__,__LINE__);

#include <stdio.h>
#include <stdlib.h>
#include <strings.h>
#include <unistd.h>
#include <sys/types.h>
#include <sys/stat.h>
#include <sys/signal.h>
#include <ctype.h>
#include <sys/time.h>
#include <sys/socket.h>
#include <netinet/in.h>
#include <netdb.h>


int main(int argc,char *argv[])
{
  char *url;
  char *host;
  struct hostent *hp;
  struct sockaddr_in soc_in;
  int s,i;
  register FILE *f;
  register int c=0;
  register int lastc=-1;
  int port=80;
  int doprint=0,dolength=0;
  unsigned int shouldlength=0, islength=0;
  static char contlength[]="Content-Length:";
  char *clp=contlength;
  
  if(argc < 3)
  {
    fprintf(stderr,
	    "usage: %s <request-string> <host> (port) (additional header lines)\n"
	    ,argv[0]);
    exit(1);
  }
  
  url =argv[1];
  host=argv[2];
  hp  =gethostbyname(host);
  if(argc > 3)
    port=atoi(argv[3]);
  
  if (hp == NULL)
  {
    static struct hostent def;
    static struct in_addr defaddr;
    static char *alist[1];
    static char namebuf[128];
    int inet_addr();
    
    defaddr.s_addr = inet_addr(host);
    if (defaddr.s_addr == -1) 
    {
      printf("unknown host: %s\n", host);
      return (1);
    }
    strcpy(namebuf, host);
    def.h_name = namebuf;
    def.h_addr_list = alist, def.h_addr = (char *)&defaddr;
    def.h_length = sizeof (struct in_addr);
    def.h_addrtype = AF_INET;
    def.h_aliases = 0;
    hp = &def;
  }
  soc_in.sin_family = hp->h_addrtype;
  bcopy(hp->h_addr, (char *)&soc_in.sin_addr, hp->h_length);
  soc_in.sin_port = htons(port);
  s = socket(hp->h_addrtype, SOCK_STREAM, 0);
  if (s < 0) 
  { 
    perror("socket");
    return (1);
  }
  fflush(stdout);
  if (connect(s, (struct sockaddr *)&soc_in, sizeof (soc_in)) < 0) 
  {   
    perror("connect");
    close(s);
    return (1);
  }
  write(s, "GET ", 4);
  write(s, url, strlen(url));
  write(s, " HTTP/1.0\n",10);
  for (i=4;i<argc;i++)
  {
    write(s, argv[i], strlen(argv[i]));
    write(s, "\n", 1);
  }
  
  write(s, "\n", 1);
  f = fdopen(s, "r");
  while ((c = getc(f)) != EOF)
  {
    if (dolength)
    {
      if(c == '\n')
      {
	dolength=0;
      }
      if((c >= '0') && (c <= '9'))
      {
	shouldlength*=10;
	shouldlength+=(c & 0xf);
      }
    }
    if (doprint)
    {
      putchar(c);
      islength++;
    }
    else
    {
      if (lastc && c == '\n')
      {
	doprint=1;
      }
      else
      {
	if (c > 31)
	  lastc = 0;
	else
	{
	  if (c == '\n')
	  {
	    lastc = 1;
	  }
	}
	if(c == *clp)
	{
	  clp++;
	  if(c == ':')
	  {
	    dolength=1;
	  }
	}
	else
	{
	  clp=contlength;
	}
      }
    }
  }
  (void)fclose(f);
  if((shouldlength != islength) && shouldlength)
  {
/*    fprintf(stderr,"%d\n%d\n",shouldlength,islength);*/
    exit(42);
  }
  exit(0);
}
