/*
 * Decompiled with CFR 0.152.
 */
package com.ctreber.acearth.shader;

import com.ctreber.acearth.projection.Projection;
import com.ctreber.acearth.util.Coordinate;
import com.ctreber.acearth.util.Point3D;
import java.awt.Color;

public abstract class Shader {
    private static final Color COLOR_SPACE = Color.black;
    private static final Color COLOR_STAR = Color.white;
    private static final Color COLOR_WATER = Color.blue;
    private static final Color COLOR_LAND = Color.green;
    private static final Color COLOR_GRID_LAND = Color.white;
    private static final Color COLOR_GRID_WATER = new Color(128, 128, 255);
    Projection fProjection;
    private Coordinate fSunPos;
    private double fNightSideBrightness;
    private double fDaySideBrightness;
    private double fTerminatorDiscontinuity;
    private double fDaySideValueBase;
    private double fDaySideValueRange;
    Point3D fLightVector;

    public abstract Color[] getShadedColors(int var1, int[] var2);

    public void init() {
        double d = this.fTerminatorDiscontinuity / 100.0;
        this.fDaySideValueBase = (int)(d * this.fDaySideBrightness + (1.0 - d) * this.fNightSideBrightness);
        this.fDaySideValueRange = this.fDaySideBrightness - this.fDaySideValueBase;
        this.fLightVector = this.fProjection.rotate(this.fSunPos.getPoint3D());
    }

    Color getShadedColorForType(int n, double d) {
        double d2 = d < 0.0 ? this.fNightSideBrightness / 100.0 : (this.fDaySideValueBase + d * this.fDaySideValueRange) / 100.0;
        if (d2 > 1.0) {
            d2 = 1.0;
        }
        switch (n) {
            case 0: {
                return COLOR_SPACE;
            }
            case 3: {
                return COLOR_STAR;
            }
            case 4: {
                return Shader.shade(COLOR_GRID_LAND, d2);
            }
            case 5: {
                return Shader.shade(COLOR_GRID_WATER, d2);
            }
            case 1: {
                return Shader.shade(COLOR_LAND, d2);
            }
            case 2: {
                return Shader.shade(COLOR_WATER, d2);
            }
        }
        return null;
    }

    private static Color shade(Color color, double d) {
        return new Color((int)((double)color.getRed() * d), (int)((double)color.getGreen() * d), (int)((double)color.getBlue() * d));
    }

    public void setProjection(Projection projection) {
        this.fProjection = projection;
    }

    public void setSunPos(Coordinate coordinate) {
        this.fSunPos = coordinate;
    }

    public void setDaySideBrightness(double d) {
        this.fDaySideBrightness = d;
    }

    public void setNightSideBrightness(double d) {
        this.fNightSideBrightness = d;
    }

    public void setTerminatorDiscontinuity(double d) {
        this.fTerminatorDiscontinuity = d;
    }
}

