# Dummy file :)
package Task::POE::All;
use strict;
use warnings;

use vars qw( $VERSION );
BEGIN {
	$VERSION = '1.02';
}

# End of module
1;
__END__

=for stopwords AnnoCPAN BiNGOs CPAN CPANPLUS CPANTS Kwalitee RT com diff github namespace

=head1 NAME

Task::POE::All - Installs all the modules in the POE::* namespace ( latest version )

=head1 DESCRIPTION

This module will use CPANPLUS to retrieve all the modules under the POE::* namespace and install them.

=head1 SEE ALSO

L<POE>

=head1 SUPPORT

You can find documentation for this module with the perldoc command.

	perldoc Task::POE::All

=head2 Websites

=over 4

=item * Search CPAN

L<http://search.cpan.org/dist/Task-POE-All>

=item * AnnoCPAN: Annotated CPAN documentation

L<http://annocpan.org/dist/Task-POE-All>

=item * CPAN Ratings

L<http://cpanratings.perl.org/d/Task-POE-All>

=item * CPAN Forum

L<http://cpanforum.com/dist/Task-POE-All>

=item * RT: CPAN's Request Tracker

L<http://rt.cpan.org/NoAuth/Bugs.html?Dist=Task-POE-All>

=item * CPANTS Kwalitee

L<http://cpants.perl.org/dist/overview/Task-POE-All>

=item * CPAN Testers Results

L<http://cpantesters.org/distro/T/Task-POE-All.html>

=item * CPAN Testers Matrix

L<http://matrix.cpantesters.org/?dist=Task-POE-All>

=item * Git Source Code Repository

This code is currently hosted on github.com under the account "apocalypse". Please feel free to browse it
and pull from it, or whatever. If you want to contribute patches, please send me a diff or prod me to pull
from your repository :)

L<http://github.com/apocalypse/perl-poe-taskall>

=back

=head2 Bugs

Please report any bugs or feature requests to C<bug-task-poe-all at rt.cpan.org>, or through
the web interface at L<http://rt.cpan.org/NoAuth/ReportBug.html?Queue=Task-POE-All>.  I will be
notified, and then you'll automatically be notified of progress on your bug as I make changes.

=head1 AUTHOR

Apocalypse E<lt>apocal@cpan.orgE<gt>

Big thanks also goes to KANE + BiNGOs for helping me navigate CPANPLUS::Backend!

=head1 COPYRIGHT AND LICENSE

Copyright 2010 by Apocalypse

This library is free software; you can redistribute it and/or modify
it under the same terms as Perl itself.

The full text of the license can be found in the LICENSE file included with this module.

=cut
