/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.plantuml.classdiagram.command;

import java.io.File;
import java.io.IOException;
import java.util.List;
import net.sourceforge.plantuml.FileSystem;
import net.sourceforge.plantuml.classdiagram.ClassDiagram;
import net.sourceforge.plantuml.classdiagram.command.JavaClass;
import net.sourceforge.plantuml.classdiagram.command.JavaFile;
import net.sourceforge.plantuml.command.CommandExecutionResult;
import net.sourceforge.plantuml.command.SingleLineCommand;
import net.sourceforge.plantuml.cucadiagram.Code;
import net.sourceforge.plantuml.cucadiagram.ILeaf;
import net.sourceforge.plantuml.cucadiagram.Link;
import net.sourceforge.plantuml.cucadiagram.LinkDecor;
import net.sourceforge.plantuml.cucadiagram.LinkType;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class CommandImport
extends SingleLineCommand<ClassDiagram> {
    public CommandImport() {
        super("(?i)^import[%s]+[%g]?([^%g]+)[%g]?$");
    }

    @Override
    protected CommandExecutionResult executeArg(ClassDiagram classDiagram, List<String> list) {
        String string = list.get(0);
        try {
            File file = FileSystem.getInstance().getFile(string);
            if (file.isFile()) {
                this.includeSimpleFile(classDiagram, file);
            } else if (file.isDirectory()) {
                this.includeDirectory(classDiagram, file);
            }
        }
        catch (IOException iOException) {
            iOException.printStackTrace();
            return CommandExecutionResult.error("IO error " + iOException);
        }
        return CommandExecutionResult.ok();
    }

    private void includeDirectory(ClassDiagram classDiagram, File file) throws IOException {
        for (File file2 : file.listFiles()) {
            this.includeSimpleFile(classDiagram, file2);
        }
    }

    private void includeSimpleFile(ClassDiagram classDiagram, File file) throws IOException {
        if (file.getName().toLowerCase().endsWith(".java")) {
            this.includeFileJava(classDiagram, file);
        }
    }

    private void includeFileJava(ClassDiagram classDiagram, File file) throws IOException {
        JavaFile javaFile = new JavaFile(file);
        for (JavaClass javaClass : javaFile.getJavaClasses()) {
            Code code = Code.of(javaClass.getName());
            ILeaf iLeaf = classDiagram.getOrCreateLeaf(code, javaClass.getType(), null);
            for (String string : javaClass.getParents()) {
                ILeaf iLeaf2 = classDiagram.getOrCreateLeaf(Code.of(string), javaClass.getParentType(), null);
                Link link = new Link(iLeaf2, iLeaf, new LinkType(LinkDecor.NONE, LinkDecor.EXTENDS), null, 2);
                classDiagram.addLink(link);
            }
        }
    }
}

