/*
 * Decompiled with CFR 0.152.
 */
package thredds.catalog2.xml.parser.stax;

import javax.xml.namespace.QName;
import javax.xml.stream.XMLEventReader;
import javax.xml.stream.events.Attribute;
import javax.xml.stream.events.StartElement;
import javax.xml.stream.events.XMLEvent;
import thredds.catalog2.builder.BuilderIssue;
import thredds.catalog2.builder.CatalogBuilder;
import thredds.catalog2.builder.DatasetNodeBuilder;
import thredds.catalog2.builder.ServiceBuilder;
import thredds.catalog2.builder.ThreddsBuilder;
import thredds.catalog2.builder.ThreddsBuilderFactory;
import thredds.catalog2.xml.names.PropertyElementNames;
import thredds.catalog2.xml.parser.ThreddsXmlParserException;
import thredds.catalog2.xml.parser.stax.AbstractElementParser;
import thredds.catalog2.xml.parser.stax.StaxThreddsXmlParserUtils;

class PropertyElementParser
extends AbstractElementParser {
    private final CatalogBuilder catBuilder;
    private final DatasetNodeBuilder datasetNodeBuilder;
    private final ServiceBuilder serviceBuilder;

    private PropertyElementParser(QName elementName, XMLEventReader reader, ThreddsBuilderFactory builderFactory, CatalogBuilder catBuilder) {
        super(elementName, reader, builderFactory);
        this.catBuilder = catBuilder;
        this.datasetNodeBuilder = null;
        this.serviceBuilder = null;
    }

    private PropertyElementParser(QName elementName, XMLEventReader reader, ThreddsBuilderFactory builderFactory, DatasetNodeBuilder datasetNodeBuilder) {
        super(elementName, reader, builderFactory);
        this.catBuilder = null;
        this.datasetNodeBuilder = datasetNodeBuilder;
        this.serviceBuilder = null;
    }

    private PropertyElementParser(QName elementName, XMLEventReader reader, ThreddsBuilderFactory builderFactory, ServiceBuilder serviceBuilder) {
        super(elementName, reader, builderFactory);
        this.catBuilder = null;
        this.datasetNodeBuilder = null;
        this.serviceBuilder = serviceBuilder;
    }

    ThreddsBuilder getSelfBuilder() {
        return null;
    }

    void parseStartElement() throws ThreddsXmlParserException {
        StartElement startElement = this.getNextEventIfStartElementIsMine();
        Attribute nameAtt = startElement.getAttributeByName(PropertyElementNames.PropertyElement_Name);
        String name = nameAtt.getValue();
        Attribute valueAtt = startElement.getAttributeByName(PropertyElementNames.PropertyElement_Value);
        String value = valueAtt.getValue();
        if (this.catBuilder != null) {
            this.catBuilder.addProperty(name, value);
        } else if (this.datasetNodeBuilder != null) {
            this.datasetNodeBuilder.addProperty(name, value);
        } else if (this.serviceBuilder != null) {
            this.serviceBuilder.addProperty(name, value);
        } else {
            throw new ThreddsXmlParserException("Unknown builder - for addProperty().");
        }
    }

    void handleChildStartElement() throws ThreddsXmlParserException {
        ThreddsBuilder parentBuilder;
        String unexpectedChildElementAsString = StaxThreddsXmlParserUtils.consumeElementAndConvertToXmlString(this.reader);
        if (this.catBuilder != null) {
            parentBuilder = this.catBuilder;
        } else if (this.datasetNodeBuilder != null) {
            parentBuilder = this.datasetNodeBuilder;
        } else if (this.serviceBuilder != null) {
            parentBuilder = this.serviceBuilder;
        } else {
            throw new ThreddsXmlParserException("Unknown parent builder.");
        }
        BuilderIssue issue = new BuilderIssue(BuilderIssue.Severity.WARNING, "Unexpected child element: " + unexpectedChildElementAsString, parentBuilder, null);
    }

    void postProcessingAfterEndElement() throws ThreddsXmlParserException {
    }

    static class Factory {
        private QName elementName = PropertyElementNames.PropertyElement;

        Factory() {
        }

        boolean isEventMyStartElement(XMLEvent event) {
            return StaxThreddsXmlParserUtils.isEventStartOrEndElementWithMatchingName(event, this.elementName);
        }

        PropertyElementParser getNewParser(XMLEventReader reader, ThreddsBuilderFactory builderFactory, CatalogBuilder parentCatalogBuilder) {
            return new PropertyElementParser(this.elementName, reader, builderFactory, parentCatalogBuilder);
        }

        PropertyElementParser getNewParser(XMLEventReader reader, ThreddsBuilderFactory builderFactory, DatasetNodeBuilder parentDatasetNodeBuilder) {
            return new PropertyElementParser(this.elementName, reader, builderFactory, parentDatasetNodeBuilder);
        }

        PropertyElementParser getNewParser(XMLEventReader reader, ThreddsBuilderFactory builderFactory, ServiceBuilder parentServiceBuilder) {
            return new PropertyElementParser(this.elementName, reader, builderFactory, parentServiceBuilder);
        }
    }
}

